/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.web.view.JsonViewUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractManagementController {
    private static final String AJAX_REQUEST_HEADER_NAME = "x-requested-with";
    private static final String AJAX_REQUEST_HEADER_VALUE = "XMLHttpRequest";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected final ReloadableServicesManager servicesManager;

    public AbstractManagementController(ReloadableServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    @ExceptionHandler
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.logger.error(ex.getMessage(), (Throwable)ex);
        String contentType = request.getHeader(AJAX_REQUEST_HEADER_NAME);
        if (contentType != null && contentType.equals(AJAX_REQUEST_HEADER_VALUE)) {
            this.logger.debug("Handling exception {} for ajax request indicated by header {}", (Object)ex.getClass().getName(), (Object)AJAX_REQUEST_HEADER_NAME);
            JsonViewUtils.renderException((Exception)ex, (HttpServletResponse)response);
            return null;
        }
        this.logger.trace("Unable to resolve exception {} for request. Ajax request header {} not found.", (Object)ex.getClass().getName(), (Object)AJAX_REQUEST_HEADER_NAME);
        response.setStatus(500);
        response.sendError(500);
        ModelAndView mv = new ModelAndView("errors");
        mv.addObject((Object)ex);
        return mv;
    }
}

