/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.web.AbstractManagementController;
import org.jasig.cas.services.web.beans.RegisteredServiceViewBean;
import org.jasig.cas.web.view.JsonViewUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public final class ManageRegisteredServicesMultiActionController
extends AbstractManagementController {
    @NotNull
    private final Service defaultService;

    @Autowired
    public ManageRegisteredServicesMultiActionController(ReloadableServicesManager servicesManager, @Value(value="${cas-management.securityContext.serviceProperties.service}") String defaultServiceUrl) {
        super(servicesManager);
        this.defaultService = new SimpleWebApplicationServiceImpl(defaultServiceUrl);
    }

    private void ensureDefaultServiceExists() {
        this.servicesManager.reload();
        Collection c = this.servicesManager.getAllServices();
        if (c == null) {
            throw new IllegalStateException("Services cannot be empty");
        }
        if (!this.servicesManager.matchesExistingService(this.defaultService)) {
            RegexRegisteredService svc = new RegexRegisteredService();
            svc.setServiceId('^' + this.defaultService.getId());
            svc.setName("Services Management Web Application");
            svc.setDescription(svc.getName());
            this.servicesManager.save((RegisteredService)svc);
        }
    }

    @RequestMapping(value={"authorizationFailure.html"}, method={RequestMethod.GET})
    public String authorizationFailureView() {
        return "authorizationFailure";
    }

    @RequestMapping(value={"logout.html"}, method={RequestMethod.GET})
    public String logoutView(HttpServletRequest request, HttpSession session) {
        this.logger.debug("Invalidating application session...");
        session.invalidate();
        return "logout";
    }

    @RequestMapping(value={"deleteRegisteredService.html"}, method={RequestMethod.POST})
    public void deleteRegisteredService(@RequestParam(value="id") long idAsLong, HttpServletResponse response) {
        RegisteredService svc = this.servicesManager.findServiceBy(this.defaultService);
        if (svc == null || svc.getId() == idAsLong) {
            throw new IllegalArgumentException("The default service " + this.defaultService.getId() + " cannot be deleted. " + "The definition is required for accessing the application.");
        }
        RegisteredService r = this.servicesManager.delete(idAsLong);
        if (r == null) {
            throw new IllegalArgumentException("Service id " + idAsLong + " cannot be found.");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("serviceName", r.getName());
        model.put("status", 200);
        JsonViewUtils.render(model, (HttpServletResponse)response);
    }

    @RequestMapping(value={"manage.html"}, method={RequestMethod.GET})
    public ModelAndView manage(HttpServletResponse response) {
        this.ensureDefaultServiceExists();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("defaultServiceUrl", this.defaultService.getId());
        model.put("status", 200);
        return new ModelAndView("manage", model);
    }

    @RequestMapping(value={"getServices.html"}, method={RequestMethod.GET})
    public void getServices(HttpServletResponse response) {
        this.ensureDefaultServiceExists();
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        ArrayList<RegisteredServiceViewBean> serviceBeans = new ArrayList<RegisteredServiceViewBean>();
        ArrayList services = new ArrayList(this.servicesManager.getAllServices());
        for (RegisteredService svc : services) {
            serviceBeans.add(RegisteredServiceViewBean.fromRegisteredService((RegisteredService)svc));
        }
        model.put("services", serviceBeans);
        model.put("status", Integer.valueOf(200));
        JsonViewUtils.render(model, (HttpServletResponse)response);
    }

    @RequestMapping(value={"updateRegisteredServiceEvaluationOrder.html"}, method={RequestMethod.POST})
    public void updateRegisteredServiceEvaluationOrder(HttpServletResponse response, long ... id) {
        if (id == null || id.length == 0) {
            throw new IllegalArgumentException("No service id was received. Re-examine the request");
        }
        for (int i = 0; i < id.length; ++i) {
            long svcId = id[i];
            RegisteredService svc = this.servicesManager.findServiceBy(svcId);
            if (svc == null) {
                throw new IllegalArgumentException("Service id " + svcId + " cannot be found.");
            }
            svc.setEvaluationOrder(i);
            this.servicesManager.save(svc);
        }
        HashMap<String, Integer> model = new HashMap<String, Integer>();
        model.put("status", 200);
        JsonViewUtils.render(model, (HttpServletResponse)response);
    }
}

