/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web.beans;

import java.io.Serializable;
import org.jasig.cas.services.AttributeReleasePolicy;
import org.jasig.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.ReturnMappedAttributeReleasePolicy;
import org.jasig.cas.services.web.beans.AbstractRegisteredServiceAttributeReleasePolicyStrategyBean;
import org.jasig.cas.services.web.beans.RegisteredServiceAttributeReleasePolicyViewBean;
import org.jasig.cas.services.web.beans.RegisteredServiceProxyPolicyBean;

public class RegisteredServiceViewBean
implements Serializable {
    private static final long serialVersionUID = 4882440567964605644L;
    private int evalOrder = Integer.MIN_VALUE;
    private String assignedId;
    private boolean sasCASEnabled;
    private String serviceId;
    private String name;
    private String description;
    private String logoUrl;
    private RegisteredServiceProxyPolicyBean proxyPolicy = new RegisteredServiceProxyPolicyBean();
    private RegisteredServiceAttributeReleasePolicyViewBean attrRelease = new RegisteredServiceAttributeReleasePolicyViewBean();

    public int getEvalOrder() {
        return this.evalOrder;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    public String getAssignedId() {
        return this.assignedId;
    }

    public void setAssignedId(String assignedId) {
        this.assignedId = assignedId;
    }

    public boolean isSasCASEnabled() {
        return this.sasCASEnabled;
    }

    public void setSasCASEnabled(boolean sasCASEnabled) {
        this.sasCASEnabled = sasCASEnabled;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public RegisteredServiceProxyPolicyBean getProxyPolicy() {
        return this.proxyPolicy;
    }

    public void setProxyPolicy(RegisteredServiceProxyPolicyBean proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    public RegisteredServiceAttributeReleasePolicyViewBean getAttrRelease() {
        return this.attrRelease;
    }

    public void setAttrRelease(RegisteredServiceAttributeReleasePolicyViewBean attrRelease) {
        this.attrRelease = attrRelease;
    }

    public static RegisteredServiceViewBean fromRegisteredService(RegisteredService svc) {
        RegisteredServiceViewBean bean = new RegisteredServiceViewBean();
        bean.setAssignedId(Long.toString(svc.getId()));
        bean.setServiceId(svc.getServiceId());
        bean.setName(svc.getName());
        bean.setDescription(svc.getDescription());
        bean.setEvalOrder(svc.getEvaluationOrder());
        if (svc.getLogo() != null) {
            bean.setLogoUrl(svc.getLogo().toExternalForm());
        }
        RegisteredServiceProxyPolicy policy = svc.getProxyPolicy();
        RegisteredServiceProxyPolicyBean proxyPolicyBean = bean.getProxyPolicy();
        if (policy instanceof RefuseRegisteredServiceProxyPolicy) {
            RefuseRegisteredServiceProxyPolicy refuse = (RefuseRegisteredServiceProxyPolicy)policy;
            proxyPolicyBean.setType(RegisteredServiceProxyPolicyBean.Types.REFUSE.toString());
        } else if (policy instanceof RegexMatchingRegisteredServiceProxyPolicy) {
            RegexMatchingRegisteredServiceProxyPolicy option = (RegexMatchingRegisteredServiceProxyPolicy)policy;
            proxyPolicyBean.setType(RegisteredServiceProxyPolicyBean.Types.REGEX.toString());
            proxyPolicyBean.setValue(option.getPattern().toString());
        }
        AttributeReleasePolicy attrPolicy = svc.getAttributeReleasePolicy();
        RegisteredServiceAttributeReleasePolicyViewBean attrPolicyBean = bean.getAttrRelease();
        attrPolicyBean.setReleasePassword(attrPolicy.isAuthorizedToReleaseCredentialPassword());
        attrPolicyBean.setReleaseTicket(attrPolicy.isAuthorizedToReleaseProxyGrantingTicket());
        if (attrPolicy instanceof ReturnAllAttributeReleasePolicy) {
            attrPolicyBean.setAttrPolicy(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.ALL.toString());
        } else if (attrPolicy instanceof ReturnAllowedAttributeReleasePolicy) {
            ReturnAllowedAttributeReleasePolicy attrPolicyAllowed = (ReturnAllowedAttributeReleasePolicy)attrPolicy;
            if (attrPolicyAllowed.getAllowedAttributes().isEmpty()) {
                attrPolicyBean.setAttrPolicy(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.NONE.toString());
            } else {
                attrPolicyBean.setAttrPolicy(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.ALLOWED.toString());
            }
        } else if (attrPolicy instanceof ReturnMappedAttributeReleasePolicy) {
            ReturnMappedAttributeReleasePolicy attrPolicyAllowed = (ReturnMappedAttributeReleasePolicy)attrPolicy;
            if (attrPolicyAllowed.getAllowedAttributes().isEmpty()) {
                attrPolicyBean.setAttrPolicy(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.NONE.toString());
            } else {
                attrPolicyBean.setAttrPolicy(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.MAPPED.toString());
            }
        }
        bean.setSasCASEnabled(svc.getAccessStrategy().isServiceAccessAllowed());
        return bean;
    }
}

