/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.AcceptUsersAuthenticationHandler$AjcClosure1;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="acceptUsersAuthenticationHandler")
public class AcceptUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_SEPARATOR = "::";
    private static final Pattern USERS_PASSWORDS_SPLITTER_PATTERN;
    private Map<String, String> users;
    @Value(value="${accept.authn.users:}")
    private String acceptedUsers;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AcceptUsersAuthenticationHandler.ajc$preClinit();
        USERS_PASSWORDS_SPLITTER_PATTERN = Pattern.compile(DEFAULT_SEPARATOR);
    }

    @PostConstruct
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AcceptUsersAuthenticationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        if (this.users == null || this.users.isEmpty()) {
            throw new FailedLoginException("No user can be accepted because none is defined");
        }
        String username = credential.getUsername();
        String cachedPassword = this.users.get(username);
        if (cachedPassword == null) {
            this.logger.debug("{} was not found in the map.", (Object)username);
            throw new AccountNotFoundException(String.valueOf(username) + " not found in backing map.");
        }
        String encodedPassword = this.getPasswordEncoder().encode(credential.getPassword());
        if (!cachedPassword.equals(encodedPassword)) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), null);
    }

    public final void setUsers(@NotNull Map<String, String> users) {
        this.users = Collections.unmodifiableMap(users);
    }

    static final /* synthetic */ void init_aroundBody0(AcceptUsersAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ajc$this.acceptedUsers) && ajc$this.users == null) {
            Set usersPasswords = StringUtils.commaDelimitedListToSet((String)ajc$this.acceptedUsers);
            HashMap<String, String> parsedUsers = new HashMap<String, String>();
            for (String usersPassword : usersPasswords) {
                String[] splitArray = USERS_PASSWORDS_SPLITTER_PATTERN.split(usersPassword);
                parsedUsers.put(splitArray[0], splitArray[1]);
            }
            ajc$this.setUsers(parsedUsers);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AcceptUsersAuthenticationHandler.java", AcceptUsersAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.jasig.cas.authentication.AcceptUsersAuthenticationHandler", "", "", "", "void"), 54);
    }
}

