/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationContext;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder$AjcClosure1;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder$AjcClosure3;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder$AjcClosure5;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder$AjcClosure7;
import org.jasig.cas.authentication.PrincipalElectionStrategy;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultAuthenticationContextBuilder
implements AuthenticationContextBuilder {
    private static final Logger LOGGER;
    private static final long serialVersionUID = 6180465589526463843L;
    private final Set<Authentication> authentications = Collections.synchronizedSet(new LinkedHashSet());
    private PrincipalElectionStrategy principalElectionStrategy;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        DefaultAuthenticationContextBuilder.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DefaultAuthenticationContextBuilder.class);
    }

    public DefaultAuthenticationContextBuilder(PrincipalElectionStrategy principalElectionStrategy) {
        this.principalElectionStrategy = principalElectionStrategy;
    }

    public AuthenticationContextBuilder collect(Authentication authentication) {
        Authentication authentication2 = authentication;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)authentication2);
        Object[] objectArray = new Object[]{this, authentication2, joinPoint};
        return (AuthenticationContextBuilder)TraceLogAspect.aspectOf().traceMethod(new DefaultAuthenticationContextBuilder$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public AuthenticationContext build() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AuthenticationContext)TraceLogAspect.aspectOf().traceMethod(new DefaultAuthenticationContextBuilder$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public AuthenticationContext build(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)service2);
        Object[] objectArray = new Object[]{this, service2, joinPoint};
        return (AuthenticationContext)TraceLogAspect.aspectOf().traceMethod(new DefaultAuthenticationContextBuilder$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean isEmpty() {
        return this.authentications.isEmpty();
    }

    private Authentication buildAuthentication() {
        if (this.isEmpty()) {
            LOGGER.warn("No authentication event has been recorded; CAS cannot finalize the authentication context");
            return null;
        }
        HashMap<String, Object> authenticationAttributes = new HashMap<String, Object>();
        HashMap<String, Object> principalAttributes = new HashMap<String, Object>();
        AuthenticationBuilder authenticationBuilder = DefaultAuthenticationBuilder.newInstance();
        this.buildAuthenticationHistory(this.authentications, authenticationAttributes, principalAttributes, authenticationBuilder);
        Principal primaryPrincipal = this.getPrimaryPrincipal(this.authentications, principalAttributes);
        authenticationBuilder.setPrincipal(primaryPrincipal);
        LOGGER.debug("Determined primary authentication principal to be [{}]", (Object)primaryPrincipal);
        authenticationBuilder.setAttributes(authenticationAttributes);
        LOGGER.debug("Collected authentication attributes for this context are [{}]", authenticationAttributes);
        DateTime dt = DateTime.now();
        authenticationBuilder.setAuthenticationDate(dt);
        LOGGER.debug("Authentication context commenced at [{}]", (Object)dt);
        return authenticationBuilder.build();
    }

    private void buildAuthenticationHistory(Set<Authentication> authentications, Map<String, Object> authenticationAttributes, Map<String, Object> principalAttributes, AuthenticationBuilder authenticationBuilder) {
        LOGGER.debug("Collecting authentication history based on [{}] authentication events", (Object)authentications.size());
        for (Authentication authn : authentications) {
            Principal authenticatedPrincipal = authn.getPrincipal();
            LOGGER.debug("Evaluating authentication principal [{}] for inclusion in context", (Object)authenticatedPrincipal);
            principalAttributes.putAll(authenticatedPrincipal.getAttributes());
            LOGGER.debug("Collected principal attributes [{}] for inclusion in context for principal [{}]", principalAttributes, (Object)authenticatedPrincipal.getId());
            for (String attrName : authn.getAttributes().keySet()) {
                if (!authenticationAttributes.containsKey(attrName)) {
                    Object value = authn.getAttributes().get(attrName);
                    if (value != null) {
                        authenticationAttributes.put(attrName, value);
                        LOGGER.debug("Collected single authentication attribute [{}] -> [{}]", (Object)attrName, value);
                        continue;
                    }
                    LOGGER.warn("Authentication attribute [{}] has no value and is not collected", (Object)attrName);
                    continue;
                }
                LOGGER.debug("Collecting multi-valued authentication attribute [{}]", (Object)attrName);
                Object oldValue = authenticationAttributes.remove(attrName);
                LOGGER.debug("Converting authentication attribute [{}] to a collection of values", (Object)attrName);
                Set<Object> listOfValues = DefaultAuthenticationContextBuilder.convertValueToCollection(oldValue);
                listOfValues.add(authn.getAttributes().get(attrName));
                authenticationAttributes.put(attrName, listOfValues);
                LOGGER.debug("Collected multi-valued authentication attribute [{}] -> [{}]", (Object)attrName, listOfValues);
            }
            LOGGER.debug("Finalized authentication attributes [{}] for inclusion in authentication context", authenticationAttributes);
            authenticationBuilder.addSuccesses(authn.getSuccesses()).addFailures(authn.getFailures()).addCredentials(authn.getCredentials());
        }
    }

    private Principal getPrimaryPrincipal(Set<Authentication> authentications, Map<String, Object> principalAttributes) {
        return this.principalElectionStrategy.nominate((Collection)ImmutableSet.copyOf(authentications), principalAttributes);
    }

    public static Set<Object> convertValueToCollection(Object obj) {
        Object object = obj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)object);
        Object[] objectArray = new Object[]{object, joinPoint};
        return (Set)TraceLogAspect.aspectOf().traceMethod(new DefaultAuthenticationContextBuilder$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536));
    }

    public void setPrincipalElectionStrategy(PrincipalElectionStrategy principalElectionStrategy) {
        this.principalElectionStrategy = principalElectionStrategy;
    }

    static final /* synthetic */ AuthenticationContextBuilder collect_aroundBody0(DefaultAuthenticationContextBuilder ajc$this, Authentication authentication, JoinPoint joinPoint) {
        ajc$this.authentications.add(authentication);
        return ajc$this;
    }

    static final /* synthetic */ AuthenticationContext build_aroundBody2(DefaultAuthenticationContextBuilder ajc$this, JoinPoint joinPoint) {
        return ajc$this.build(null);
    }

    static final /* synthetic */ AuthenticationContext build_aroundBody4(DefaultAuthenticationContextBuilder ajc$this, Service service, JoinPoint joinPoint) {
        Authentication authentication = ajc$this.buildAuthentication();
        if (authentication == null) {
            LOGGER.info("Authentication context cannot be produced because no authentication is recorded into in the chain. Returning null");
            return null;
        }
        LOGGER.debug("Building an authentication context for authentication {} and service {}", (Object)authentication, (Object)service);
        return new DefaultAuthenticationContext(authentication, service);
    }

    static final /* synthetic */ Set convertValueToCollection_aroundBody6(Object obj, JoinPoint joinPoint) {
        HashSet<Object> c = new HashSet<Object>();
        if (obj instanceof Collection) {
            c.addAll((Collection)obj);
            LOGGER.debug("Converting multi-valued attribute [{}] for the authentication context", obj);
        } else {
            if (obj instanceof Map) {
                throw new UnsupportedOperationException(String.valueOf(Map.class.getCanonicalName()) + " is not supported");
            }
            if (obj.getClass().isArray()) {
                c.addAll(Arrays.asList((Object[])obj));
                LOGGER.debug("Converting array attribute [{}] for the authentication context", obj);
            } else {
                c.add(obj);
                LOGGER.debug("Converting attribute [{}] for the authentication context", obj);
            }
        }
        return c;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultAuthenticationContextBuilder.java", DefaultAuthenticationContextBuilder.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "collect", "org.jasig.cas.authentication.DefaultAuthenticationContextBuilder", "org.jasig.cas.authentication.Authentication", "authentication", "", "org.jasig.cas.authentication.AuthenticationContextBuilder"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "build", "org.jasig.cas.authentication.DefaultAuthenticationContextBuilder", "", "", "", "org.jasig.cas.authentication.AuthenticationContext"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "build", "org.jasig.cas.authentication.DefaultAuthenticationContextBuilder", "org.jasig.cas.authentication.principal.Service", "service", "", "org.jasig.cas.authentication.AuthenticationContext"), 54);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertValueToCollection", "org.jasig.cas.authentication.DefaultAuthenticationContextBuilder", "java.lang.Object", "obj", "", "java.util.Set"), 152);
    }
}

