/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal.cache;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure1;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure11;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure13;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure3;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure5;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure7;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$AjcClosure9;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure1;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure3;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure5;
import org.jasig.cas.util.ApplicationContextProvider;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.jasig.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPrincipalAttributesRepository
implements PrincipalAttributesRepository,
Closeable {
    private static final TimeUnit DEFAULT_CACHE_EXPIRATION_UNIT;
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 2L;
    private static final long serialVersionUID = 6350245643948535906L;
    private static final Logger LOGGER;
    protected final long expiration;
    protected final TimeUnit timeUnit;
    protected MergingStrategy mergingStrategy;
    private transient IPersonAttributeDao attributeRepository;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        AbstractPrincipalAttributesRepository.ajc$preClinit();
        DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.HOURS;
        LOGGER = LoggerFactory.getLogger(AbstractPrincipalAttributesRepository.class);
    }

    protected AbstractPrincipalAttributesRepository() {
        this(2L, DEFAULT_CACHE_EXPIRATION_UNIT);
    }

    public AbstractPrincipalAttributesRepository(long expiration, TimeUnit timeUnit) {
        this.expiration = expiration;
        this.timeUnit = timeUnit;
    }

    public final void setMergingStrategy(MergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public final MergingStrategy getMergingStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (MergingStrategy)((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    protected final Map<String, Object> convertPersonAttributesToPrincipalAttributes(Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        Iterator<Map.Entry<String, List<Object>>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Object> values;
            Map.Entry<String, List<Object>> entry;
            convertedAttributes.put(entry.getKey(), (values = (entry = iterator.next()).getValue()).size() == 1 ? values.get(0) : values);
        }
        return convertedAttributes;
    }

    private Map<String, List<Object>> convertPrincipalAttributesToPersonAttributes(Principal p) {
        HashMap<String, List<Object>> convertedAttributes = new HashMap<String, List<Object>>(p.getAttributes().size());
        Map principalAttributes = p.getAttributes();
        for (Map.Entry entry : principalAttributes.entrySet()) {
            Object values = entry.getValue();
            String key = (String)entry.getKey();
            if (values instanceof List) {
                convertedAttributes.put(key, (List)values);
                continue;
            }
            convertedAttributes.put(key, Collections.singletonList(values));
        }
        return convertedAttributes;
    }

    protected final Map<String, List<Object>> retrievePersonAttributesToPrincipalAttributes(String id) {
        IPersonAttributes attrs = this.getAttributeRepository().getPerson(id);
        if (attrs == null) {
            LOGGER.debug("Could not find principal [{}] in the repository so no attributes are returned.", (Object)id);
            return Collections.emptyMap();
        }
        Map attributes = attrs.getAttributes();
        if (attributes == null) {
            LOGGER.debug("Principal [{}] has no attributes and so none are returned.", (Object)id);
            return Collections.emptyMap();
        }
        return attributes;
    }

    public final Map<String, Object> getAttributes(Principal p) {
        Principal principal = p;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)principal);
        Object[] objectArray = new Object[]{this, principal, joinPoint};
        return (Map)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Map<String, Object> convertAttributesToPrincipalAttributesAndCache(Principal p, Map<String, List<Object>> sourceAttributes) {
        Map<String, Object> finalAttributes = this.convertPersonAttributesToPrincipalAttributes(sourceAttributes);
        this.addPrincipalAttributes(p.getId(), finalAttributes);
        return finalAttributes;
    }

    protected abstract void addPrincipalAttributes(String var1, Map<String, Object> var2);

    protected abstract Map<String, Object> getPrincipalAttributes(Principal var1);

    public void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    private IPersonAttributeDao getAttributeRepository() {
        if (this.attributeRepository == null) {
            ApplicationContext context = ApplicationContextProvider.getApplicationContext();
            if (context != null) {
                return (IPersonAttributeDao)context.getBean("attributeRepository", IPersonAttributeDao.class);
            }
            LOGGER.warn("No application context could be retrieved, so no attribute repository instance can be determined.");
        }
        return this.attributeRepository;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public long getExpiration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.longValue((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public TimeUnit getTimeUnit() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (TimeUnit)((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)object);
        Object[] objectArray = new Object[]{this, object, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static final /* synthetic */ MergingStrategy getMergingStrategy_aroundBody0(AbstractPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.mergingStrategy;
    }

    static final /* synthetic */ Map getAttributes_aroundBody2(AbstractPrincipalAttributesRepository ajc$this, Principal p, JoinPoint joinPoint) {
        Map<String, Object> cachedAttributes = ajc$this.getPrincipalAttributes(p);
        if (cachedAttributes != null && !cachedAttributes.isEmpty()) {
            LOGGER.debug("Found [{}] cached attributes for principal [{}]", (Object)cachedAttributes.size(), (Object)p.getId());
            return cachedAttributes;
        }
        if (ajc$this.getAttributeRepository() == null) {
            LOGGER.debug("No attribute repository is defined for [{}]. Returning default principal attributes for {}", (Object)ajc$this.getClass().getName(), (Object)p.getId());
            return cachedAttributes;
        }
        Map<String, List<Object>> sourceAttributes = ajc$this.retrievePersonAttributesToPrincipalAttributes(p.getId());
        LOGGER.debug("Found [{}] attributes for principal [{}] from the attribute repository.", (Object)sourceAttributes.size(), (Object)p.getId());
        if (ajc$this.mergingStrategy == null || ajc$this.mergingStrategy.getAttributeMerger() == null) {
            LOGGER.debug("No merging strategy found, so attributes retrieved from the repository will be used instead.");
            return ajc$this.convertAttributesToPrincipalAttributesAndCache(p, sourceAttributes);
        }
        Map<String, List<Object>> principalAttributes = ajc$this.convertPrincipalAttributesToPersonAttributes(p);
        LOGGER.debug("Merging current principal attributes with that of the repository via strategy [{}]", (Object)((Object)((Object)ajc$this.mergingStrategy)).getClass().getSimpleName());
        Map mergedAttributes = ajc$this.mergingStrategy.getAttributeMerger().mergeAttributes(principalAttributes, sourceAttributes);
        return ajc$this.convertAttributesToPrincipalAttributesAndCache(p, mergedAttributes);
    }

    static final /* synthetic */ String toString_aroundBody4(AbstractPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return new ToStringBuilder((Object)ajc$this).append("mergingStrategy", (Object)ajc$this.mergingStrategy).append("expiration", ajc$this.expiration).append("timeUnit", (Object)ajc$this.timeUnit).toString();
    }

    static final /* synthetic */ long getExpiration_aroundBody6(AbstractPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.expiration;
    }

    static final /* synthetic */ TimeUnit getTimeUnit_aroundBody8(AbstractPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.timeUnit;
    }

    static final /* synthetic */ boolean equals_aroundBody10(AbstractPrincipalAttributesRepository ajc$this, Object obj, JoinPoint joinPoint) {
        if (obj == null) {
            return false;
        }
        if (obj == ajc$this) {
            return true;
        }
        if (obj.getClass() != ajc$this.getClass()) {
            return false;
        }
        AbstractPrincipalAttributesRepository rhs = (AbstractPrincipalAttributesRepository)obj;
        return new EqualsBuilder().append((Object)ajc$this.timeUnit, (Object)rhs.timeUnit).append(ajc$this.expiration, rhs.expiration).isEquals();
    }

    static final /* synthetic */ int hashCode_aroundBody12(AbstractPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return new HashCodeBuilder(13, 133).append((Object)ajc$this.timeUnit).append(ajc$this.expiration).toHashCode();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractPrincipalAttributesRepository.java", AbstractPrincipalAttributesRepository.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getMergingStrategy", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "", "", "", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy"), 123);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getAttributes", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "org.jasig.cas.authentication.principal.Principal", "p", "", "java.util.Map"), 188);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "", "", "", "java.lang.String"), 267);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpiration", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "", "", "", "long"), 275);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeUnit", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "", "", "", "java.util.concurrent.TimeUnit"), 279);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "java.lang.Object", "obj", "", "boolean"), 284);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository", "", "", "", "int"), 302);
    }

    public static final class MergingStrategy
    extends Enum<MergingStrategy> {
        public static final /* enum */ MergingStrategy REPLACE;
        public static final /* enum */ MergingStrategy ADD;
        public static final /* enum */ MergingStrategy NONE;
        public static final /* enum */ MergingStrategy MULTIVALUED;
        private static final /* synthetic */ MergingStrategy[] ENUM$VALUES;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            MergingStrategy.ajc$preClinit();
            REPLACE = new MergingStrategy();
            ADD = new MergingStrategy();
            NONE = new MergingStrategy();
            MULTIVALUED = new MergingStrategy();
            ENUM$VALUES = new MergingStrategy[]{REPLACE, ADD, NONE, MULTIVALUED};
        }

        public IAttributeMerger getAttributeMerger() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
            Object[] objectArray = new Object[]{this, joinPoint};
            return (IAttributeMerger)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        public static MergingStrategy[] values() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            Object[] objectArray = new Object[]{joinPoint};
            return (MergingStrategy[])TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }

        public static MergingStrategy valueOf(String arg0) {
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            Object[] objectArray = new Object[]{string, joinPoint};
            return (MergingStrategy)((Object)TraceLogAspect.aspectOf().traceMethod(new AbstractPrincipalAttributesRepository$MergingStrategy$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536)));
        }

        static final /* synthetic */ IAttributeMerger getAttributeMerger_aroundBody0(MergingStrategy ajc$this, JoinPoint joinPoint) {
            String name = ajc$this.name().toUpperCase();
            switch (name.toUpperCase()) {
                case "REPLACE": {
                    return new ReplacingAttributeAdder();
                }
                case "ADD": {
                    return new NoncollidingAttributeAdder();
                }
                case "MULTIVALUED": {
                    return new MultivaluedAttributeMerger();
                }
            }
            return null;
        }

        static final /* synthetic */ MergingStrategy[] values_aroundBody2(JoinPoint joinPoint) {
            MergingStrategy[] mergingStrategyArray = ENUM$VALUES;
            int n = mergingStrategyArray.length;
            MergingStrategy[] mergingStrategyArray2 = new MergingStrategy[n];
            System.arraycopy(ENUM$VALUES, 0, mergingStrategyArray2, 0, n);
            return mergingStrategyArray2;
        }

        static final /* synthetic */ MergingStrategy valueOf_aroundBody4(String string, JoinPoint joinPoint) {
            return Enum.valueOf(MergingStrategy.class, string);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AbstractPrincipalAttributesRepository.java", MergingStrategy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributeMerger", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy", "", "", "", "org.jasig.services.persondir.support.merger.IAttributeMerger"), 75);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy", "", "", "", "[Lorg.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy", "java.lang.String", "arg0", "", "org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository$MergingStrategy"), 1);
        }
    }
}

