/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository$1$AjcClosure1;
import org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository$AjcClosure1;
import org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository$PrincipalAttributesCacheLoader$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingPrincipalAttributesRepository
extends AbstractPrincipalAttributesRepository {
    private static final long serialVersionUID = 6350244643948535906L;
    private static final long DEFAULT_MAXIMUM_CACHE_SIZE = 1000L;
    private static final Logger LOGGER;
    private final transient Cache<String, Map<String, Object>> cache;
    private final transient PrincipalAttributesCacheLoader cacheLoader = new PrincipalAttributesCacheLoader();
    private long maxCacheSize = 1000L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        CachingPrincipalAttributesRepository.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(CachingPrincipalAttributesRepository.class);
    }

    private CachingPrincipalAttributesRepository() {
        this.cache = CacheBuilder.newBuilder().maximumSize(this.maxCacheSize).expireAfterWrite(this.expiration, this.timeUnit).build((CacheLoader)this.cacheLoader);
    }

    public CachingPrincipalAttributesRepository(TimeUnit timeUnit, long expiryDuration) {
        this(1000L, timeUnit, expiryDuration);
    }

    public CachingPrincipalAttributesRepository(long maxCacheSize, TimeUnit timeUnit, long expiryDuration) {
        super(expiryDuration, timeUnit);
        this.maxCacheSize = maxCacheSize;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxCacheSize).expireAfterWrite(expiryDuration, timeUnit).build((CacheLoader)this.cacheLoader);
    }

    @Override
    protected void addPrincipalAttributes(String id, Map<String, Object> attributes) {
        this.cache.put((Object)id, attributes);
        LOGGER.debug("Cached attributes for {}", (Object)id);
    }

    @Override
    protected Map<String, Object> getPrincipalAttributes(final Principal p) {
        try {
            return (Map)this.cache.get((Object)p.getId(), (Callable)new Callable<Map<String, Object>>(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                @Override
                public Map<String, Object> call() throws Exception {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Object[] objectArray = new Object[]{this, joinPoint};
                    return (Map)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$1$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
                }

                static {
                    1.ajc$preClinit();
                }

                static final /* synthetic */ Map call_aroundBody0(1 ajc$this, JoinPoint joinPoint) {
                    LOGGER.debug("No cached attributes could be found for {}", (Object)ajc$this.p.getId());
                    return new HashMap();
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("CachingPrincipalAttributesRepository.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository$1", "", "", "java.lang.Exception", "java.util.Map"), 81);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void close_aroundBody0(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        ajc$this.cache.cleanUp();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CachingPrincipalAttributesRepository.java", CachingPrincipalAttributesRepository.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository", "", "", "java.io.IOException", "void"), 93);
    }

    private static class PrincipalAttributesCacheLoader
    extends CacheLoader<String, Map<String, Object>> {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private PrincipalAttributesCacheLoader() {
        }

        public Map<String, Object> load(String key) throws Exception {
            String string = key;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Map)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$PrincipalAttributesCacheLoader$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            PrincipalAttributesCacheLoader.ajc$preClinit();
        }

        static final /* synthetic */ Map load_aroundBody0(PrincipalAttributesCacheLoader ajc$this, String key, JoinPoint joinPoint) {
            return new HashMap();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("CachingPrincipalAttributesRepository.java", PrincipalAttributesCacheLoader.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "load", "org.jasig.cas.authentication.principal.cache.CachingPrincipalAttributesRepository$PrincipalAttributesCacheLoader", "java.lang.String", "key", "java.lang.Exception", "java.util.Map"), 99);
        }
    }
}

