/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.List;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.ServiceRegistryInitializer$AjcClosure1;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="serviceRegistryInitializer")
class ServiceRegistryInitializer {
    private static final Logger LOGGER;
    private final ServiceRegistryDao serviceRegistryDao;
    private final ServiceRegistryDao jsonServiceRegistryDao;
    @Value(value="${svcreg.database.from.json:false}")
    private boolean initFromJsonIfAvailable;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ServiceRegistryInitializer.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ServiceRegistryInitializer.class);
    }

    @Autowired
    ServiceRegistryInitializer(@Qualifier(value="jsonServiceRegistryDao") ServiceRegistryDao jsonServiceRegistryDao, @Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        this.jsonServiceRegistryDao = jsonServiceRegistryDao;
        this.serviceRegistryDao = serviceRegistryDao;
    }

    @PostConstruct
    public void initServiceRegistryIfNecessary() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new ServiceRegistryInitializer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void initServiceRegistryIfNecessary_aroundBody0(ServiceRegistryInitializer ajc$this, JoinPoint joinPoint) {
        if (ajc$this.serviceRegistryDao.equals(ajc$this.jsonServiceRegistryDao)) {
            return;
        }
        if (ajc$this.initFromJsonIfAvailable) {
            long size = ajc$this.serviceRegistryDao.load().size();
            if (size == 0L) {
                LOGGER.debug("Service registry database will be auto-initialized from default JSON services");
                List services = ajc$this.jsonServiceRegistryDao.load();
                for (RegisteredService r : services) {
                    LOGGER.debug("Initializing DB with the {} JSON service definition...", (Object)r);
                    ajc$this.serviceRegistryDao.save(r);
                }
                ajc$this.serviceRegistryDao.load();
                LOGGER.info("The service registry database is  initialized from default JSON services.");
            } else {
                LOGGER.debug("Service registry database contains {} service definitions", (Object)size);
            }
        } else {
            LOGGER.info("The service registry database will not be initialized from default JSON services. If the service registry database is empty, CAS will refuse to authenticate services until service definitions are added to the database.");
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServiceRegistryInitializer.java", ServiceRegistryInitializer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initServiceRegistryIfNecessary", "org.jasig.cas.ServiceRegistryInitializer", "", "", "", "void"), 48);
    }
}

