/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.http;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.http.SimpleHttpClient;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure1;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure11;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure13;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure15;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure17;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure19;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure21;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure23;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure25;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure27;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure29;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure3;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure31;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure33;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure35;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure37;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure39;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure41;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure43;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure45;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure47;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure49;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure5;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure7;
import org.jasig.cas.util.http.SimpleHttpClientFactoryBean$AjcClosure9;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

public class SimpleHttpClientFactoryBean
implements FactoryBean<SimpleHttpClient> {
    public static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final Logger LOGGER;
    private static final int MAX_POOLED_CONNECTIONS = 100;
    private static final int DEFAULT_THREADS_NUMBER = 200;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int[] DEFAULT_ACCEPTABLE_CODES;
    private static final int DEFAULT_QUEUE_SIZE = 40;
    private int threadsNumber = 200;
    private int queueSize = 40;
    private int maxPooledConnections = 100;
    private int maxConnectionsPerRoute = 50;
    @NotNull
    @Size(min=1)
    private List<Integer> acceptableCodes = Ints.asList((int[])DEFAULT_ACCEPTABLE_CODES);
    @Min(value=0L)
    private int connectionTimeout = 5000;
    @Min(value=0L)
    private int readTimeout = 5000;
    private RedirectStrategy redirectionStrategy = new DefaultRedirectStrategy();
    private SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
    private HostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
    private CredentialsProvider credentialsProvider;
    private CookieStore cookieStore;
    private ConnectionReuseStrategy connectionReuseStrategy = new DefaultConnectionReuseStrategy();
    private ConnectionBackoffStrategy connectionBackoffStrategy = new DefaultBackoffStrategy();
    private ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy();
    private Collection<? extends Header> defaultHeaders = Collections.emptyList();
    private AuthenticationStrategy proxyAuthenticationStrategy = new ProxyAuthenticationStrategy();
    private boolean circularRedirectsAllowed = true;
    private boolean authenticationEnabled;
    private boolean redirectsEnabled = true;
    private ExecutorService executorService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;

    static {
        SimpleHttpClientFactoryBean.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SimpleHttpClientFactoryBean.class);
        DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    }

    public SimpleHttpClient getObject() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (SimpleHttpClient)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Class<?> getObjectType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Class)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean isSingleton() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private CloseableHttpClient buildHttpClient() {
        try {
            PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
            SSLConnectionSocketFactory sslsf = this.sslSocketFactory;
            Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
            PoolingHttpClientConnectionManager connMgmr = new PoolingHttpClientConnectionManager(registry);
            connMgmr.setMaxTotal(this.maxPooledConnections);
            connMgmr.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            connMgmr.setValidateAfterInactivity(5000);
            HttpHost httpHost = new HttpHost(InetAddress.getLocalHost());
            HttpRoute httpRoute = new HttpRoute(httpHost);
            connMgmr.setMaxPerRoute(httpRoute, 50);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionTimeout).setCircularRedirectsAllowed(this.circularRedirectsAllowed).setRedirectsEnabled(this.redirectsEnabled).setAuthenticationEnabled(this.authenticationEnabled).build();
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgmr).setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setSSLHostnameVerifier(this.hostnameVerifier).setRedirectStrategy(this.redirectionStrategy).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultCookieStore(this.cookieStore).setConnectionReuseStrategy(this.connectionReuseStrategy).setConnectionBackoffStrategy(this.connectionBackoffStrategy).setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy).setProxyAuthenticationStrategy(this.proxyAuthenticationStrategy).setDefaultHeaders(this.defaultHeaders).useSystemProperties();
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private FutureRequestExecutionService buildRequestExecutorService(CloseableHttpClient httpClient) {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(this.threadsNumber, this.threadsNumber, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize));
        }
        return new FutureRequestExecutionService((HttpClient)httpClient, this.executorService);
    }

    public ExecutorService getExecutorService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ExecutorService)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public int getThreadsNumber() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setThreadsNumber(int threadsNumber) {
        this.threadsNumber = threadsNumber;
    }

    public int getQueueSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getMaxPooledConnections() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setMaxPooledConnections(int maxPooledConnections) {
        this.maxPooledConnections = maxPooledConnections;
    }

    public int getMaxConnectionsPerRoute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public List<Integer> getAcceptableCodes() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = Ints.asList((int[])acceptableCodes);
    }

    public int getConnectionTimeout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Autowired
    public void setConnectionTimeout(@Value(value="${http.client.connection.timeout:5000}") int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Autowired
    public void setReadTimeout(@Value(value="${http.client.read.timeout:5000}") int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public RedirectStrategy getRedirectionStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (RedirectStrategy)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setRedirectionStrategy(RedirectStrategy redirectionStrategy) {
        this.redirectionStrategy = redirectionStrategy;
    }

    public SSLConnectionSocketFactory getSslSocketFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (SSLConnectionSocketFactory)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setSslSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (HostnameVerifier)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public CredentialsProvider getCredentialsProvider() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (CredentialsProvider)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CookieStore getCookieStore() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (CookieStore)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure31(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public ConnectionReuseStrategy getConnectionReuseStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ConnectionReuseStrategy)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure33(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connectionReuseStrategy = connectionReuseStrategy;
    }

    public ConnectionBackoffStrategy getConnectionBackoffStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ConnectionBackoffStrategy)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure35(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.connectionBackoffStrategy = connectionBackoffStrategy;
    }

    public ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ServiceUnavailableRetryStrategy)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure37(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this.serviceUnavailableRetryStrategy = serviceUnavailableRetryStrategy;
    }

    public Collection<? extends Header> getDefaultHeaders() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure39(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public AuthenticationStrategy getProxyAuthenticationStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AuthenticationStrategy)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure41(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthenticationStrategy) {
        this.proxyAuthenticationStrategy = proxyAuthenticationStrategy;
    }

    public boolean isCircularRedirectsAllowed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure43(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
        this.circularRedirectsAllowed = circularRedirectsAllowed;
    }

    public boolean isAuthenticationEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure45(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public boolean isRedirectsEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure47(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    @PreDestroy
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new SimpleHttpClientFactoryBean$AjcClosure49(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ SimpleHttpClient getObject_aroundBody0(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        CloseableHttpClient httpClient = ajc$this.buildHttpClient();
        FutureRequestExecutionService requestExecutorService = ajc$this.buildRequestExecutorService(httpClient);
        return new SimpleHttpClient(ajc$this.acceptableCodes, httpClient, requestExecutorService);
    }

    static final /* synthetic */ Class getObjectType_aroundBody2(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return SimpleHttpClient.class;
    }

    static final /* synthetic */ boolean isSingleton_aroundBody4(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return false;
    }

    static final /* synthetic */ ExecutorService getExecutorService_aroundBody6(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.executorService;
    }

    static final /* synthetic */ int getThreadsNumber_aroundBody8(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.threadsNumber;
    }

    static final /* synthetic */ int getQueueSize_aroundBody10(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.queueSize;
    }

    static final /* synthetic */ int getMaxPooledConnections_aroundBody12(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.maxPooledConnections;
    }

    static final /* synthetic */ int getMaxConnectionsPerRoute_aroundBody14(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.maxConnectionsPerRoute;
    }

    static final /* synthetic */ List getAcceptableCodes_aroundBody16(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ImmutableList.copyOf(ajc$this.acceptableCodes);
    }

    static final /* synthetic */ int getConnectionTimeout_aroundBody18(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.connectionTimeout;
    }

    static final /* synthetic */ int getReadTimeout_aroundBody20(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.readTimeout;
    }

    static final /* synthetic */ RedirectStrategy getRedirectionStrategy_aroundBody22(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.redirectionStrategy;
    }

    static final /* synthetic */ SSLConnectionSocketFactory getSslSocketFactory_aroundBody24(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.sslSocketFactory;
    }

    static final /* synthetic */ HostnameVerifier getHostnameVerifier_aroundBody26(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.hostnameVerifier;
    }

    static final /* synthetic */ CredentialsProvider getCredentialsProvider_aroundBody28(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.credentialsProvider;
    }

    static final /* synthetic */ CookieStore getCookieStore_aroundBody30(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.cookieStore;
    }

    static final /* synthetic */ ConnectionReuseStrategy getConnectionReuseStrategy_aroundBody32(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.connectionReuseStrategy;
    }

    static final /* synthetic */ ConnectionBackoffStrategy getConnectionBackoffStrategy_aroundBody34(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.connectionBackoffStrategy;
    }

    static final /* synthetic */ ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy_aroundBody36(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.serviceUnavailableRetryStrategy;
    }

    static final /* synthetic */ Collection getDefaultHeaders_aroundBody38(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.defaultHeaders;
    }

    static final /* synthetic */ AuthenticationStrategy getProxyAuthenticationStrategy_aroundBody40(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.proxyAuthenticationStrategy;
    }

    static final /* synthetic */ boolean isCircularRedirectsAllowed_aroundBody42(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.circularRedirectsAllowed;
    }

    static final /* synthetic */ boolean isAuthenticationEnabled_aroundBody44(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.authenticationEnabled;
    }

    static final /* synthetic */ boolean isRedirectsEnabled_aroundBody46(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        return ajc$this.redirectsEnabled;
    }

    static final /* synthetic */ void destroy_aroundBody48(SimpleHttpClientFactoryBean ajc$this, JoinPoint joinPoint) {
        if (ajc$this.executorService != null) {
            ajc$this.executorService.shutdownNow();
            ajc$this.executorService = null;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SimpleHttpClientFactoryBean.java", SimpleHttpClientFactoryBean.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "java.lang.Exception", "org.jasig.cas.util.http.SimpleHttpClient"), 162);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObjectType", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "java.lang.Class"), 172);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReadTimeout", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 312);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRedirectionStrategy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.RedirectStrategy"), 322);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSslSocketFactory", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.conn.ssl.SSLConnectionSocketFactory"), 330);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHostnameVerifier", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "javax.net.ssl.HostnameVerifier"), 338);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCredentialsProvider", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.CredentialsProvider"), 346);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCookieStore", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.CookieStore"), 354);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionReuseStrategy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.ConnectionReuseStrategy"), 362);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionBackoffStrategy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.ConnectionBackoffStrategy"), 370);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getServiceUnavailableRetryStrategy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.ServiceUnavailableRetryStrategy"), 378);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultHeaders", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "java.util.Collection"), 386);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSingleton", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "boolean"), 177);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProxyAuthenticationStrategy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "org.apache.http.client.AuthenticationStrategy"), 394);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCircularRedirectsAllowed", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "boolean"), 402);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAuthenticationEnabled", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "boolean"), 410);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRedirectsEnabled", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "boolean"), 418);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "void"), 430);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExecutorService", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "java.util.concurrent.ExecutorService"), 254);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getThreadsNumber", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 262);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueueSize", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 270);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxPooledConnections", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 278);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxConnectionsPerRoute", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 286);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAcceptableCodes", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "java.util.List"), 294);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionTimeout", "org.jasig.cas.util.http.SimpleHttpClientFactoryBean", "", "", "", "int"), 302);
    }

    @Component(value="httpClient")
    public static class DefaultHttpClient
    extends SimpleHttpClientFactoryBean {
    }

    @Component(value="noRedirectHttpClient")
    public static class NoRedirectHttpClient
    extends SslTrustStoreAwareHttpClient {
        public NoRedirectHttpClient() {
            super.setRedirectsEnabled(false);
            super.setCircularRedirectsAllowed(false);
        }
    }

    @Component(value="supportsTrustStoreSslSocketFactoryHttpClient")
    public static class SslTrustStoreAwareHttpClient
    extends DefaultHttpClient {
        @Override
        @Autowired
        public void setSslSocketFactory(@Qualifier(value="trustStoreSslSocketFactory") SSLConnectionSocketFactory sslSocketFactory) {
            super.setSslSocketFactory(sslSocketFactory);
        }
    }
}

