/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.support.CasAttributeEncoder;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.web.view.AbstractCasView$AjcClosure1;
import org.jasig.cas.services.web.view.AbstractCasView$AjcClosure3;
import org.jasig.cas.validation.Assertion;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractCasView
extends AbstractView {
    protected boolean successResponse;
    @NotNull
    @Resource(name="casAttributeEncoder")
    protected CasAttributeEncoder casAttributeEncoder;
    @NotNull
    @Resource(name="servicesManager")
    protected ServicesManager servicesManager;
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected final Assertion getAssertionFrom(Map<String, Object> model) {
        return (Assertion)model.get("assertion");
    }

    protected final String getErrorCodeFrom(Map<String, Object> model) {
        return model.get("code").toString();
    }

    protected final String getErrorDescriptionFrom(Map<String, Object> model) {
        return model.get("description").toString();
    }

    protected final String getProxyGrantingTicketId(Map<String, Object> model) {
        return (String)model.get("proxyGrantingTicket");
    }

    protected final Authentication getPrimaryAuthenticationFrom(Map<String, Object> model) {
        return this.getAssertionFrom(model).getPrimaryAuthentication();
    }

    protected final String getAuthenticationAttribute(Map<String, Object> model, String attributeName) {
        Authentication authn = this.getPrimaryAuthenticationFrom(model);
        return (String)authn.getAttributes().get(attributeName);
    }

    protected final Principal getPrincipal(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getPrincipal();
    }

    protected final Map<String, Object> getPrincipalAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return AbstractCasView.convertAttributeValuesToMultiValuedObjects(this.getPrincipal(model).getAttributes());
    }

    protected final Map<String, Object> getAuthenticationAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return AbstractCasView.convertAttributeValuesToMultiValuedObjects(this.getPrimaryAuthenticationFrom(model).getAttributes());
    }

    protected final boolean isRememberMeAuthentication(Map<String, Object> model) {
        Map<String, Object> authnAttributes = this.getAuthenticationAttributesAsMultiValuedAttributes(model);
        Collection authnMethod = (Collection)authnAttributes.get("org.jasig.cas.authentication.principal.REMEMBER_ME");
        return authnMethod != null && authnMethod.contains(Boolean.TRUE) && this.isAssertionBackedByNewLogin(model);
    }

    protected final boolean isAssertionBackedByNewLogin(Map<String, Object> model) {
        return this.getAssertionFrom(model).isFromNewLogin();
    }

    private static Map<String, Object> convertAttributeValuesToMultiValuedObjects(Map<String, Object> attributes) {
        HashMap<String, Object> attributesToReturn = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value = entry.getValue();
            if (value instanceof Collection || value instanceof Map || value instanceof Object[] || value instanceof Iterator || value instanceof Enumeration) {
                attributesToReturn.put(entry.getKey(), value);
                continue;
            }
            attributesToReturn.put(entry.getKey(), Collections.singleton(value));
        }
        return attributesToReturn;
    }

    protected final DateTime getAuthenticationDate(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getAuthenticationDate();
    }

    protected final Service getServiceFrom(Map<String, Object> model) {
        return (Service)model.get("service");
    }

    protected final Collection<Authentication> getChainedAuthentications(Map<String, Object> model) {
        ArrayList<Authentication> chainedAuthenticationsToReturn = new ArrayList<Authentication>();
        Assertion assertion = this.getAssertionFrom(model);
        List chainedAuthentications = assertion.getChainedAuthentications();
        int numberAuthenticationsExceptPrimary = chainedAuthentications.size() - 1;
        int i = 0;
        while (i < numberAuthenticationsExceptPrimary) {
            chainedAuthenticationsToReturn.add((Authentication)chainedAuthentications.get(i));
            ++i;
        }
        return chainedAuthenticationsToReturn;
    }

    protected void decideIfCredentialPasswordShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseCredentialPassword();
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getAuthenticationAttribute(model, "credential"), "credential", service, isAuthorized);
    }

    protected void decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseProxyGrantingTicket();
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getProxyGrantingTicketId(model), "proxyGrantingTicket", service, isAuthorized);
    }

    protected void decideAttributeReleaseBasedOnServiceAttributePolicy(Map<String, Object> attributes, String attributeValue, String attributeName, RegisteredService service, boolean doesAttributePolicyAllow) {
        if (StringUtils.isNotBlank((CharSequence)attributeValue)) {
            this.logger.debug("Obtained [{}] as an authentication attribute", (Object)attributeName);
            if (doesAttributePolicyAllow) {
                this.logger.debug("Obtained [{}] is passed to the CAS validation payload", (Object)attributeName);
                attributes.put(attributeName, Collections.singleton(attributeValue));
            } else {
                this.logger.debug("Attribute release policy for [{}] does not authorize the release of [{}]", (Object)service.getServiceId(), (Object)attributeName);
                attributes.remove(attributeName);
            }
        } else {
            this.logger.trace("[{}] is not available and will not be released to the validation response.", (Object)attributeName);
        }
    }

    protected final void putIntoModel(Map<String, Object> model, String key, Object value) {
        model.put(key, value);
    }

    protected final void putAllIntoModel(Map<String, Object> model, Map<String, Object> values) {
        model.putAll(values);
    }

    public void setServicesManager(@NotNull ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setCasAttributeEncoder(@NotNull CasAttributeEncoder casAttributeEncoder) {
        this.casAttributeEncoder = casAttributeEncoder;
    }

    public CasAttributeEncoder getCasAttributeEncoder() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (CasAttributeEncoder)TraceLogAspect.aspectOf().traceMethod(new AbstractCasView$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public ServicesManager getServicesManager() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ServicesManager)TraceLogAspect.aspectOf().traceMethod(new AbstractCasView$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void setSuccessResponse(boolean successResponse) {
        this.successResponse = successResponse;
    }

    static {
        AbstractCasView.ajc$preClinit();
    }

    static final /* synthetic */ CasAttributeEncoder getCasAttributeEncoder_aroundBody0(AbstractCasView ajc$this, JoinPoint joinPoint) {
        return ajc$this.casAttributeEncoder;
    }

    static final /* synthetic */ ServicesManager getServicesManager_aroundBody2(AbstractCasView ajc$this, JoinPoint joinPoint) {
        return ajc$this.servicesManager;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractCasView.java", AbstractCasView.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCasAttributeEncoder", "org.jasig.cas.services.web.view.AbstractCasView", "", "", "", "org.jasig.cas.authentication.support.CasAttributeEncoder"), 367);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getServicesManager", "org.jasig.cas.services.web.view.AbstractCasView", "", "", "", "org.jasig.cas.services.ServicesManager"), 371);
    }
}

