/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.web.flow.AbstractCasWebflowConfigurer$AjcClosure1;
import org.jasig.cas.web.flow.BasicSubflowExpression;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.service.RuntimeBindingConversionExecutor;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.spel.SpringELExpressionParser;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.ViewFactoryActionAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.engine.support.GenericSubflowAttributeMapper;
import org.springframework.webflow.engine.support.TransitionExecutingFlowExecutionExceptionHandler;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.expression.spel.ActionPropertyAccessor;
import org.springframework.webflow.expression.spel.BeanFactoryPropertyAccessor;
import org.springframework.webflow.expression.spel.FlowVariablePropertyAccessor;
import org.springframework.webflow.expression.spel.MapAdaptablePropertyAccessor;
import org.springframework.webflow.expression.spel.MessageSourcePropertyAccessor;
import org.springframework.webflow.expression.spel.ScopeSearchingPropertyAccessor;

@Component(value="casWebflowConfigurer")
public abstract class AbstractCasWebflowConfigurer {
    protected static final String TRANSITION_ID_SUCCESS = "success";
    protected static final String STATE_ID_VIEW_LOGIN_FORM = "viewLoginForm";
    protected static final String TRANSITION_ID_YES = "yes";
    protected static final String TRANSITION_ID_NO = "no";
    protected static final String TRANSITION_ID_SUBMIT = "submit";
    protected static final String TRANSITION_ID_GENERATED = "generated";
    protected static final String TRANSITION_ID_ERROR = "error";
    protected static final String TRANSITION_ID_WARN = "warn";
    protected static final String TRANSITION_ID_SEND_TICKET_GRANTING_TICKET = "sendTicketGrantingTicket";
    protected static final String STATE_ID_GENERATE_LOGIN_TICKET = "generateLoginTicket";
    private static final String FLOW_ID_LOGIN = "login";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="logoutFlowRegistry")
    private FlowDefinitionRegistry logoutFlowDefinitionRegistry;
    @Autowired
    private WebApplicationContext webApplicationContext;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public final void initialize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new AbstractCasWebflowConfigurer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected abstract void doInitialize() throws Exception;

    protected Flow getLoginFlow() {
        Flow flow = (Flow)this.loginFlowDefinitionRegistry.getFlowDefinition(FLOW_ID_LOGIN);
        return flow;
    }

    protected List<String> getFlowDefinitionIds() {
        return Arrays.asList(this.loginFlowDefinitionRegistry.getFlowDefinitionIds());
    }

    protected List<String> getFlowDefinitionIds(String[] excludedFlowIds) {
        Object[] flowIds = this.loginFlowDefinitionRegistry.getFlowDefinitionIds();
        String[] stringArray = excludedFlowIds;
        int n = excludedFlowIds.length;
        int n2 = 0;
        while (n2 < n) {
            String flowId = stringArray[n2];
            flowIds = (String[])ArrayUtils.removeElement((Object[])flowIds, (Object)flowId);
            ++n2;
        }
        return Arrays.asList(flowIds);
    }

    protected TransitionableState getStartState(Flow flow) {
        TransitionableState currentStartState = (TransitionableState)TransitionableState.class.cast(flow.getStartState());
        return currentStartState;
    }

    protected ActionState createActionState(Flow flow, String name, Action ... actions) {
        ActionState actionState = new ActionState(flow, name);
        this.logger.debug("Created action state {}", (Object)actionState.getId());
        actionState.getActionList().addAll(actions);
        this.logger.debug("Added action to the action state {} list of actions: {}", (Object)actionState.getId(), (Object)actionState.getActionList());
        return actionState;
    }

    protected DecisionState createDecisionState(Flow flow, String id, String testExpression, String thenStateId, String elseStateId) {
        DecisionState decisionState = new DecisionState(flow, id);
        Expression expression = this.createExpression(flow, testExpression, Boolean.class);
        Transition thenTransition = this.createTransition(expression, thenStateId);
        decisionState.getTransitionSet().add(thenTransition);
        Transition elseTransition = this.createTransition("*", elseStateId);
        decisionState.getTransitionSet().add(elseTransition);
        return decisionState;
    }

    protected void setStartState(Flow flow, String state) {
        flow.setStartState(state);
        TransitionableState startState = this.getStartState(flow);
        this.logger.debug("Start state is now set to {}", (Object)startState.getId());
    }

    protected void setStartState(Flow flow, TransitionableState state) {
        this.setStartState(flow, state.getId());
    }

    protected void createGlobalTransition(Flow flow, String targetStateId, Class<? extends Throwable> clazz) {
        try {
            TransitionExecutingFlowExecutionExceptionHandler handler = new TransitionExecutingFlowExecutionExceptionHandler();
            TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(TargetStateResolver.class).execute((Object)targetStateId);
            handler.add(clazz, targetStateResolver);
            this.logger.debug("Added transition {} to execute on the occurrence of {}", (Object)targetStateId, (Object)clazz.getName());
            flow.getExceptionHandlerSet().add((FlowExecutionExceptionHandler)handler);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected ConversionExecutor fromStringTo(Class targetType) {
        return this.flowBuilderServices.getConversionService().getConversionExecutor(String.class, targetType);
    }

    private Class toClass(String name) {
        Class clazz = this.flowBuilderServices.getConversionService().getClassForAlias(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            ClassLoader classLoader = this.flowBuilderServices.getApplicationContext().getClassLoader();
            return ClassUtils.forName((String)name, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to load class " + name);
        }
    }

    protected EvaluateAction createEvaluateAction(String expression) {
        FluentParserContext ctx = new FluentParserContext();
        Expression action = this.flowBuilderServices.getExpressionParser().parseExpression(expression, (ParserContext)ctx);
        EvaluateAction newAction = new EvaluateAction(action, null);
        this.logger.debug("Created evaluate action for expression {}", (Object)action.getExpressionString());
        return newAction;
    }

    protected void createStateDefaultTransition(TransitionableState state, String targetState) {
        if (state == null) {
            this.logger.debug("Cannot add default transition of [{}] to the given state is null and cannot be found in the flow.", (Object)targetState);
            return;
        }
        Transition transition = this.createTransition(targetState);
        state.getTransitionSet().add(transition);
    }

    protected void createTransitionForState(TransitionableState state, String criteriaOutcome, String targetState) {
        try {
            Transition transition = this.createTransition(criteriaOutcome, targetState);
            state.getTransitionSet().add(transition);
            this.logger.debug("Added transition {} to the state {}", (Object)transition.getId(), (Object)state.getId());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected Transition createTransition(String criteriaOutcome, String targetState) {
        return this.createTransition((Expression)new LiteralExpression(criteriaOutcome), targetState);
    }

    protected Transition createTransition(String criteriaOutcome, TransitionableState targetState) {
        return this.createTransition((Expression)new LiteralExpression(criteriaOutcome), targetState.getId());
    }

    protected Transition createTransition(Expression criteriaOutcomeExpression, String targetState) {
        Object criteria = criteriaOutcomeExpression.toString().equals("*") ? WildcardTransitionCriteria.INSTANCE : new DefaultTransitionCriteria(criteriaOutcomeExpression);
        DefaultTargetStateResolver resolver = new DefaultTargetStateResolver(targetState);
        return new Transition((TransitionCriteria)criteria, (TargetStateResolver)resolver);
    }

    protected Expression createExpression(Flow flow, String expression, Class expectedType) {
        FluentParserContext parserContext = new FluentParserContext().expectResult(expectedType);
        return this.getSpringExpressionParser().parseExpression(expression, (ParserContext)parserContext);
    }

    protected SpringELExpressionParser getSpringExpressionParser() {
        SpelParserConfiguration configuration = new SpelParserConfiguration();
        SpelExpressionParser spelExpressionParser = new SpelExpressionParser(configuration);
        SpringELExpressionParser parser = new SpringELExpressionParser(spelExpressionParser, this.flowBuilderServices.getConversionService());
        parser.addPropertyAccessor((PropertyAccessor)new ActionPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new BeanFactoryPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new FlowVariablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAdaptablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MessageSourcePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new ScopeSearchingPropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new MapAdaptablePropertyAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        parser.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        return parser;
    }

    protected Transition createTransition(String targetState) {
        DefaultTargetStateResolver resolver = new DefaultTargetStateResolver(targetState);
        return new Transition((TargetStateResolver)resolver);
    }

    protected void createEndState(Flow flow, String id, String viewId) {
        this.createEndState(flow, id, (Expression)new LiteralExpression(viewId));
    }

    protected void createEndState(Flow flow, String id, Expression expression) {
        ViewFactory viewFactory = this.flowBuilderServices.getViewFactoryCreator().createViewFactory(expression, this.flowBuilderServices.getExpressionParser(), this.flowBuilderServices.getConversionService(), null, this.flowBuilderServices.getValidator(), this.flowBuilderServices.getValidationHintResolver());
        this.createEndState(flow, id, viewFactory);
    }

    protected void createEndState(Flow flow, String id, ViewFactory viewFactory) {
        try {
            EndState endState = new EndState(flow, id);
            ViewFactoryActionAdapter finalResponseAction = new ViewFactoryActionAdapter(viewFactory);
            endState.setFinalResponseAction((Action)finalResponseAction);
            this.logger.debug("Created end state state {} on flow id {}, backed by view factory {}", new Object[]{id, flow.getId(), viewFactory});
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected ViewState createViewState(Flow flow, String id, Expression expression) {
        try {
            ViewFactory viewFactory = this.flowBuilderServices.getViewFactoryCreator().createViewFactory(expression, this.flowBuilderServices.getExpressionParser(), this.flowBuilderServices.getConversionService(), null, this.flowBuilderServices.getValidator(), this.flowBuilderServices.getValidationHintResolver());
            ViewState viewState = new ViewState(flow, id, viewFactory);
            this.logger.debug("Added view state {}", (Object)viewState.getId());
            return viewState;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected ViewState createViewState(Flow flow, String id, String viewId) {
        return this.createViewState(flow, id, (Expression)new LiteralExpression(viewId));
    }

    protected SubflowState createSubflowState(Flow flow, String id, String subflow, Action entryAction) {
        SubflowState state = new SubflowState(flow, id, (Expression)new BasicSubflowExpression(subflow, this.loginFlowDefinitionRegistry));
        if (entryAction != null) {
            state.getEntryActionList().add(entryAction);
        }
        return state;
    }

    protected Mapper createMapperToSubflowState(List<DefaultMapping> mappings) {
        DefaultMapper inputMapper = new DefaultMapper();
        for (DefaultMapping mapping : mappings) {
            inputMapper.addMapping(mapping);
        }
        return inputMapper;
    }

    protected DefaultMapping createMappingToSubflowState(String name, String value, boolean required, Class type) {
        ExpressionParser parser = this.flowBuilderServices.getExpressionParser();
        Expression source = parser.parseExpression(value, (ParserContext)new FluentParserContext());
        Expression target = parser.parseExpression(name, (ParserContext)new FluentParserContext());
        DefaultMapping mapping = new DefaultMapping(source, target);
        mapping.setRequired(required);
        RuntimeBindingConversionExecutor typeConverter = new RuntimeBindingConversionExecutor(type, this.flowBuilderServices.getConversionService());
        mapping.setTypeConverter((ConversionExecutor)typeConverter);
        return mapping;
    }

    protected SubflowAttributeMapper createSubflowAttributeMapper(Mapper inputMapper, Mapper outputMapper) {
        return new GenericSubflowAttributeMapper(inputMapper, outputMapper);
    }

    static {
        AbstractCasWebflowConfigurer.ajc$preClinit();
    }

    static final /* synthetic */ void initialize_aroundBody0(AbstractCasWebflowConfigurer ajc$this, JoinPoint joinPoint) {
        try {
            ajc$this.logger.debug("Initializing CAS webflow configuration...");
            ajc$this.doInitialize();
        }
        catch (Exception e) {
            ajc$this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractCasWebflowConfigurer.java", AbstractCasWebflowConfigurer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "initialize", "org.jasig.cas.web.flow.AbstractCasWebflowConfigurer", "", "", "", "void"), 139);
    }
}

