/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.principal.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlAuthenticationMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    private static final String ATTRIBUTE_AUTHENTICATION_METHOD = "samlAuthenticationStatement::authMethod";
    private Map<String, String> authenticationMethods = new HashMap<String, String>();

    public SamlAuthenticationMetaDataPopulator() {
        this.authenticationMethods.put("org.jasig.cas.authentication.principal.HttpBasedServiceCredentials", "urn:ietf:rfc:2246");
        this.authenticationMethods.put("org.jasig.cas.authentication.principal.UsernamePasswordCredentials", "urn:oasis:names:tc:SAML:1.0:am:password");
        this.authenticationMethods.put("org.jasig.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredentials", "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        this.authenticationMethods.put("org.jasig.cas.adaptors.x509.authentication.principal.X509CertificateCredentials", "urn:oasis:names:tc:SAML:1.0:am:X509-PKI");
    }

    @Override
    public final Authentication populateAttributes(Authentication authentication, Credentials credentials) {
        String credentialsClass = credentials.getClass().getName();
        String authenticationMetehod = this.authenticationMethods.get(credentialsClass);
        authentication.getAttributes().put(ATTRIBUTE_AUTHENTICATION_METHOD, authenticationMetehod);
        return authentication;
    }

    public void setUserDefinedMappings(Map<String, String> userDefinedMappings) {
        this.authenticationMethods.putAll(userDefinedMappings);
    }
}

