/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.inspektr.common.ioc.annotation.IsIn;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.AbstractPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

public final class CredentialsToLDAPAttributePrincipalResolver
extends AbstractPersonDirectoryCredentialsToPrincipalResolver {
    private static final int DEFAULT_MAX_NUMBER_OF_RESULTS = 2;
    private static final int DEFAULT_TIMEOUT = 1000;
    @NotNull
    private CredentialsToPrincipalResolver credentialsToPrincipalResolver;
    @NotNull
    private LdapTemplate ldapTemplate;
    @NotNull
    private String filter;
    @NotNull
    private String[] attributeIds;
    @NotNull
    private String searchBase;
    @IsIn(value={0, 1, 2})
    private int scope = 2;
    private int timeout = 1000;

    private SearchControls getSearchControls() {
        SearchControls constraints = new SearchControls();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("returning searchcontrols: scope=" + this.scope + "; search base=" + this.searchBase + "; attributes=" + Arrays.toString(this.attributeIds) + "; timeout=" + this.timeout));
        }
        constraints.setSearchScope(this.scope);
        constraints.setReturningAttributes(this.attributeIds);
        constraints.setTimeLimit(this.timeout);
        constraints.setCountLimit(2L);
        return constraints;
    }

    protected String extractPrincipalId(Credentials credentials) {
        String ldapPrincipal;
        Principal principal = this.credentialsToPrincipalResolver.resolvePrincipal(credentials);
        if (principal == null) {
            this.log.info((Object)"Initial principal could not be resolved from request, returning null");
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Resolved " + principal + ". Trying LDAP resolve now..."));
        }
        if ((ldapPrincipal = this.resolveFromLDAP(principal.getId())) == null) {
            this.log.info((Object)("Initial principal \"" + principal.getId() + "\" was not found in LDAP, returning null"));
        } else {
            this.log.debug((Object)("Resolved " + principal + " to " + ldapPrincipal));
        }
        return ldapPrincipal;
    }

    private String resolveFromLDAP(String lookupAttributeValue) {
        String searchFilter = LdapUtils.getFilterWithValues(this.filter, lookupAttributeValue);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("LDAP search with filter \"" + searchFilter + "\""));
        }
        try {
            final String idAttribute = this.attributeIds[0];
            List principalList = this.ldapTemplate.search(this.searchBase, searchFilter, this.getSearchControls(), new AttributesMapper(){

                public Object mapFromAttributes(Attributes attrs) throws NamingException {
                    Attribute attribute = attrs.get(idAttribute);
                    if (attribute == null) {
                        CredentialsToLDAPAttributePrincipalResolver.this.log.debug((Object)("Principal attribute \"" + idAttribute + "\" " + "not found in LDAP search results. Returning null."));
                        return null;
                    }
                    return attribute.get();
                }
            });
            if (principalList.isEmpty()) {
                this.log.debug((Object)"LDAP search returned zero results.");
                return null;
            }
            if (principalList.size() > 1) {
                this.log.error((Object)("LDAP search returned multiple results for filter \"" + searchFilter + "\", " + "which is not allowed."));
                return null;
            }
            return (String)principalList.get(0);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public boolean supports(Credentials credentials) {
        return this.credentialsToPrincipalResolver.supports(credentials);
    }

    public final void setCredentialsToPrincipalResolver(CredentialsToPrincipalResolver credentialsToPrincipalResolver) {
        this.credentialsToPrincipalResolver = credentialsToPrincipalResolver;
    }

    public final void setContextSource(LdapContextSource contextSource) {
        this.ldapTemplate = new LdapTemplate((ContextSource)contextSource);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public final void setPrincipalAttributeName(String principalAttributeName) {
        this.attributeIds = new String[]{principalAttributeName};
    }

    public final void setScope(int scope) {
        this.scope = scope;
    }

    public final void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public final void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

