/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class ThrottledSubmissionByIpAddressHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int MAX_SIZE_OF_MAP_ARRAY = 256;
    private static final BigInteger DEFAULT_FAILURE_THRESHHOLD = BigInteger.valueOf(100L);
    private static final int DEFAULT_FAILURE_TIMEOUT = 60;
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<String, BigInteger>[] restrictedIpAddressMaps = new Map[256];
    private BigInteger failureThreshhold = DEFAULT_FAILURE_THRESHHOLD;
    int failureTimeout = 60;

    public ThrottledSubmissionByIpAddressHandlerInterceptorAdapter() {
        for (int i = 0; i < 256; ++i) {
            this.restrictedIpAddressMaps[i] = new HashMap<String, BigInteger>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!request.getMethod().equals("GET") || !"casLoginView".equals(modelAndView.getViewName())) {
            return;
        }
        String remoteAddr = request.getRemoteAddr();
        try {
            Map<String, BigInteger> quadMap;
            String lastQuad = remoteAddr.substring(remoteAddr.lastIndexOf(".") + 1);
            int intVersionOfLastQuad = Integer.parseInt(lastQuad);
            Map<String, BigInteger> map = quadMap = this.restrictedIpAddressMaps[intVersionOfLastQuad - 1];
            synchronized (map) {
                BigInteger original = quadMap.get(lastQuad);
                BigInteger integer = ONE;
                if (original != null) {
                    integer = original.add(ONE);
                }
                quadMap.put(lastQuad, integer);
                if (integer.compareTo(this.failureThreshhold) == 1) {
                    this.log.warn((Object)("Possible hacking attack from " + remoteAddr + ". More than " + this.failureThreshhold + " failed login attempts within " + this.failureTimeout + " seconds."));
                    modelAndView.setViewName("casFailureAuthenticationThreshhold");
                }
            }
        }
        catch (NumberFormatException e) {
            this.log.warn((Object)("Skipping ip-address blocking. Possible reason: IPv6 Address not supported: " + e.getMessage()));
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage());
        }
    }

    public void setFailureThreshhold(BigInteger failureThreshhold) {
        this.failureThreshhold = failureThreshhold;
    }

    public void setFailureTimeout(int failureTimeout) {
        this.failureTimeout = failureTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        ExpirationThread thread = new ExpirationThread(this.restrictedIpAddressMaps, this.failureTimeout);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ExpirationThread
    extends Thread {
        private Map<String, BigInteger>[] restrictedIpAddressMaps;
        private int failureTimeout;

        public ExpirationThread(Map<String, BigInteger>[] restrictedIpAddressMaps, int failureTimeout) {
            this.restrictedIpAddressMaps = restrictedIpAddressMaps;
            this.failureTimeout = failureTimeout;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.failureTimeout * 60);
                        this.cleanUpFailures();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUpFailures() {
            int length = this.restrictedIpAddressMaps.length;
            for (int i = 0; i < length; ++i) {
                Map<String, BigInteger> map;
                Map<String, BigInteger> map2 = map = this.restrictedIpAddressMaps[i];
                synchronized (map2) {
                    for (String key : map.keySet()) {
                        BigInteger integer = map.get(key);
                        BigInteger newValue = integer.subtract(ONE);
                        if (newValue.equals(BigInteger.ZERO)) {
                            map.remove(key);
                            continue;
                        }
                        map.put(key, newValue);
                    }
                    continue;
                }
            }
        }
    }
}

