/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.util.HttpClient;

public final class HttpBasedServiceCredentialsAuthenticationHandler
implements AuthenticationHandler {
    private static final String PROTOCOL_HTTPS = "https";
    private boolean requireSecure = true;
    private final Log log = LogFactory.getLog(this.getClass());
    private HttpClient httpClient;

    public boolean authenticate(Credentials credentials) {
        HttpBasedServiceCredentials serviceCredentials = (HttpBasedServiceCredentials)credentials;
        if (this.requireSecure && !serviceCredentials.getCallbackUrl().getProtocol().equals(PROTOCOL_HTTPS)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Authentication failed because url was not secure.");
            }
            return false;
        }
        this.log.debug((Object)("Attempting to resolve credentials for " + serviceCredentials));
        return this.httpClient.isValidEndPoint(serviceCredentials.getCallbackUrl());
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && HttpBasedServiceCredentials.class.isAssignableFrom(credentials.getClass());
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setRequireSecure(boolean requireSecure) {
        this.requireSecure = requireSecure;
    }
}

