/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web.support;

import org.inspektr.common.ioc.annotation.GreaterThan;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public final class RegisteredServiceValidator
implements Validator {
    private static final int DEFAULT_MAX_DESCRIPTION_LENGTH = 300;
    @NotNull
    private ServicesManager servicesManager;
    @GreaterThan(value=0)
    private int maxDescriptionLength = 300;

    public boolean supports(Class clazz) {
        return RegisteredServiceImpl.class.equals((Object)clazz);
    }

    public void validate(Object o, Errors errors) {
        RegisteredService r = (RegisteredService)o;
        if (r.getServiceId() != null) {
            for (RegisteredService service : this.servicesManager.getAllServices()) {
                if (!r.getServiceId().equals(service.getServiceId()) || r.getId() == service.getId()) continue;
                errors.rejectValue("serviceId", "registeredService.serviceId.exists", null);
                break;
            }
        }
        if (r.getDescription() != null && r.getDescription().length() > this.maxDescriptionLength) {
            errors.rejectValue("description", "registeredService.description.length", null);
        }
    }

    public void setServicesManager(ServicesManager serviceRegistry) {
        this.servicesManager = serviceRegistry;
    }

    public void setMaxDescriptionLength(int maxLength) {
        this.maxDescriptionLength = maxLength;
    }
}

