/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TICKETGRANTINGTICKET")
public final class TicketGrantingTicketImpl
extends AbstractTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = -5197946718924166491L;
    @Lob
    @Column(name="AUTHENTICATION", nullable=false)
    private Authentication authentication;
    @Column(name="EXPIRED", nullable=false)
    private Boolean expired = false;
    @Lob
    @Column(name="SERVICES_GRANTED_ACCESS_TO", nullable=false)
    private final HashMap<String, Service> services = new HashMap();

    public TicketGrantingTicketImpl() {
    }

    public TicketGrantingTicketImpl(String id, TicketGrantingTicketImpl ticketGrantingTicket, Authentication authentication, ExpirationPolicy policy) {
        super(id, ticketGrantingTicket, policy);
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.authentication = authentication;
    }

    public TicketGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        this(id, null, authentication, policy);
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public synchronized ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(id, this, service, this.getCountOfUses() == 0 || credentialsProvided, expirationPolicy);
        this.updateState();
        List<Authentication> authentications = this.getChainedAuthentications();
        service.setPrincipal(authentications.get(authentications.size() - 1).getPrincipal());
        this.services.put(id, service);
        return serviceTicket;
    }

    private void logOutOfServices() {
        for (Map.Entry<String, Service> entry : this.services.entrySet()) {
            entry.getValue().logOutOfService(entry.getKey());
        }
    }

    @Override
    public boolean isRoot() {
        return this.getGrantingTicket() == null;
    }

    @Override
    public synchronized void expire() {
        this.expired = true;
        this.logOutOfServices();
    }

    @Override
    public boolean isExpiredInternal() {
        return this.expired;
    }

    @Override
    public List<Authentication> getChainedAuthentications() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        if (this.getGrantingTicket() == null) {
            list.add(this.getAuthentication());
            return Collections.unmodifiableList(list);
        }
        list.add(this.getAuthentication());
        list.addAll(this.getGrantingTicket().getChainedAuthentications());
        return Collections.unmodifiableList(list);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof TicketGrantingTicket)) {
            return false;
        }
        Ticket ticket = (Ticket)object;
        return ticket.getId().equals(this.getId());
    }
}

