/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.transaction.annotation.Transactional;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;

    @Transactional(readOnly=false)
    public void clean() {
        ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
        this.log.info((Object)("Starting cleaning of expired tickets from ticket registry at [" + new Date() + "]"));
        Collection<Ticket> ticketsInCache = this.ticketRegistry.getTickets();
        for (Ticket ticket : ticketsInCache) {
            if (!ticket.isExpired()) continue;
            ticketsToRemove.add(ticket);
        }
        this.log.info((Object)(ticketsToRemove.size() + " found to be removed.  Removing now."));
        for (Ticket ticket : ticketsToRemove) {
            this.ticketRegistry.deleteTicket(ticket.getId());
        }
        this.log.info((Object)("Finished cleaning of expired tickets from ticket registry at [" + new Date() + "]"));
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

