/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.audit.annotation.Auditable;
import org.inspektr.audit.spi.support.ObjectCreationAuditableActionResolver;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.audit.spi.CredentialsAsFirstParameterResourceResolver;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationManagerImpl;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.NamedAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationManager
implements AuthenticationManager {
    protected final Log log = LogFactory.getLog(AuthenticationManagerImpl.class);
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();

    @Override
    @Auditable(action="AUTHENTICATION", successSuffix="_SUCCESS", failureSuffix="_FAILED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=CredentialsAsFirstParameterResourceResolver.class)
    public final Authentication authenticate(Credentials credentials) throws AuthenticationException {
        Pair<AuthenticationHandler, Principal> pair = this.authenticateAndObtainPrincipal(credentials);
        Authentication authentication = new MutableAuthentication(pair.getSecond());
        if (pair.getFirst() instanceof NamedAuthenticationHandler) {
            NamedAuthenticationHandler a = (NamedAuthenticationHandler)pair.getFirst();
            authentication.getAttributes().put("authenticationMethod", a.getName());
        }
        for (AuthenticationMetaDataPopulator authenticationMetaDataPopulator : this.authenticationMetaDataPopulators) {
            authentication = authenticationMetaDataPopulator.populateAttributes(authentication, credentials);
        }
        return new ImmutableAuthentication(authentication.getPrincipal(), authentication.getAttributes());
    }

    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators) {
        this.authenticationMetaDataPopulators = authenticationMetaDataPopulators;
    }

    protected abstract Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials var1) throws AuthenticationException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pair<A, B> {
        private final A first;
        private final B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }
}

