/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SamlService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.SamlUtils;
import org.jasig.cas.util.UniqueTicketIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebApplicationService
implements WebApplicationService {
    protected static final Log LOG = LogFactory.getLog(SamlService.class);
    private static final Map<String, Object> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static final UniqueTicketIdGenerator GENERATOR = new DefaultUniqueTicketIdGenerator();
    private final String id;
    private final String originalUrl;
    private final String artifactId;
    private Principal principal;
    private boolean loggedOutAlready = false;
    private final HttpClient httpClient;

    protected AbstractWebApplicationService(String id, String originalUrl, String artifactId, HttpClient httpClient) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.artifactId = artifactId;
        this.httpClient = httpClient;
    }

    public final String toString() {
        return this.id;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return EMPTY_MAP;
    }

    protected static final String cleanupUrl(String url) {
        if (url == null) {
            return null;
        }
        int jsessionPosition = url.indexOf(";jsession");
        if (jsessionPosition == -1) {
            return url;
        }
        int questionMarkPosition = url.indexOf("?");
        if (questionMarkPosition < jsessionPosition) {
            return url.substring(0, url.indexOf(";jsession"));
        }
        return url.substring(0, jsessionPosition) + url.substring(questionMarkPosition);
    }

    protected final String getOriginalUrl() {
        return this.originalUrl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.getId().equals(service.getId());
        }
        return false;
    }

    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    protected Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    @Override
    public boolean matches(Service service) {
        return this.id.equals(service.getId());
    }

    @Override
    public synchronized boolean logOutOfService(String sessionIdentifier) {
        if (this.loggedOutAlready) {
            return true;
        }
        LOG.debug((Object)("Sending logout request for: " + this.getId()));
        String logoutRequest = "<samlp:LogoutRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" ID=\"" + GENERATOR.getNewTicketId("LR") + "\" Version=\"2.0\" IssueInstant=\"" + SamlUtils.getCurrentDateAndTime() + "\"><saml:NameID xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\">@NOT_USED@</saml:NameID><samlp:SessionIndex>" + sessionIdentifier + "</samlp:SessionIndex></samlp:LogoutRequest>";
        this.loggedOutAlready = true;
        if (this.httpClient != null) {
            return this.httpClient.sendMessageToEndPoint(this.getOriginalUrl(), logoutRequest, true);
        }
        return false;
    }
}

