/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.util.HttpClient;
import org.springframework.util.StringUtils;

public final class SamlService
extends AbstractWebApplicationService {
    private static final String CONST_PARAM_SERVICE = "TARGET";
    private static final String CONST_PARAM_TICKET = "SAMLart";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";
    private static final long serialVersionUID = -6867572626767140223L;

    protected SamlService(String id) {
        super(id, id, null, new HttpClient());
    }

    protected SamlService(String id, String originalUrl, String artifactId, HttpClient httpClient) {
        super(id, originalUrl, artifactId, httpClient);
    }

    public boolean matches(Service service) {
        return true;
    }

    public static SamlService createServiceFrom(HttpServletRequest request, HttpClient httpClient) {
        String artifactId;
        String service = request.getParameter(CONST_PARAM_SERVICE);
        String requestBody = SamlService.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            return null;
        }
        String id = SamlService.cleanupUrl(service);
        if (StringUtils.hasText((String)requestBody)) {
            int startTagLocation = requestBody.indexOf(CONST_START_ARTIFACT_XML_TAG);
            int artifactStartLocation = startTagLocation + CONST_START_ARTIFACT_XML_TAG.length();
            int endTagLocation = requestBody.indexOf(CONST_END_ARTIFACT_XML_TAG);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
        } else {
            artifactId = null;
        }
        return new SamlService(id, service, artifactId, httpClient);
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(CONST_PARAM_TICKET, ticketId);
        parameters.put(CONST_PARAM_SERVICE, this.getOriginalUrl());
        return Response.getRedirectResponse(this.getOriginalUrl(), parameters);
    }

    protected static String getRequestBody(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

