/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.init;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ContextLoaderListener;

public final class SafeContextLoaderListener
implements ServletContextListener {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String CAUGHT_THROWABLE_KEY = "exceptionCaughtByListener";
    private final ContextLoaderListener delegate = new ContextLoaderListener();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.delegate.contextInitialized(sce);
        }
        catch (Throwable t) {
            String message = "SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.";
            this.log.fatal((Object)"SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.", t);
            System.err.println("SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.");
            t.printStackTrace();
            ServletContext context = sce.getServletContext();
            context.log("SafeContextLoaderListener: \nThe Spring ContextLoaderListener we wrap threw on contextInitialized.\nBut for our having caught this error, the web application context would not have initialized.", t);
            context.setAttribute(CAUGHT_THROWABLE_KEY, (Object)t);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.delegate.contextDestroyed(sce);
    }
}

