/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.GreaterThan;
import org.inspektr.common.ioc.annotation.NotNull;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    private static final int DEFAULT_FAILURE_THRESHOLD = 100;
    private static final int DEFAULT_FAILURE_RANGE_IN_SECONDS = 60;
    private static final String DEFAULT_USERNAME_PARAMETER = "username";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    @GreaterThan(value=0)
    private int failureThreshold = 100;
    @GreaterThan(value=0)
    private int failureRangeInSeconds = 60;
    @NotNull
    private String usernameParameter = "username";

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!"POST".equals(request.getMethod())) {
            return true;
        }
        int count = this.findCount(request, this.usernameParameter, this.failureRangeInSeconds);
        if (count >= this.failureThreshold) {
            this.updateCount(request, this.usernameParameter);
            this.log.warn((Object)("*** Possible Hacking Attempt from [" + request.getRemoteAddr() + "].  More than " + this.failureThreshold + " failed login attempts within " + this.failureRangeInSeconds + " seconds."));
            response.sendError(403, "Access Denied for user [" + request.getParameter(this.usernameParameter) + " from IP Address [" + request.getRemoteAddr() + "]");
            return false;
        }
        return true;
    }

    public final void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        if (!"POST".equals(request.getMethod())) {
            return;
        }
        if (!"casLoginView".equals(modelAndView.getViewName())) {
            return;
        }
        this.updateCount(request, this.usernameParameter);
    }

    protected abstract int findCount(HttpServletRequest var1, String var2, int var3);

    protected abstract void updateCount(HttpServletRequest var1, String var2);

    public final void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public final void setFailureRangeInSeconds(int failureRangeInSeconds) {
        this.failureRangeInSeconds = failureRangeInSeconds;
    }

    public final void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }
}

