/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.inspektr.audit.AuditTrailManager;
import org.inspektr.audit.AuditableActionContext;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.springframework.jdbc.core.JdbcTemplate;

public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final String DEFAULT_APPLICATION_CODE = "CAS";
    private static final String INSPEKTR_ACTION = "THROTTLED_LOGIN_ATTEMPT";
    private final AuditTrailManager auditTrailManager;
    private final JdbcTemplate jdbcTemplate;
    private String applicationCode = "CAS";

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(AuditTrailManager auditTrailManager, DataSource dataSource) {
        this.auditTrailManager = auditTrailManager;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected final int findCount(HttpServletRequest request, String usernameParameter, int failureRangeInSeconds) {
        String SQL = "Select count(*) from COM_AUDIT_TRAIL where AUD_CLIENT_IP = ? and AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ?";
        String userToUse = this.constructUsername(request, usernameParameter);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1 * failureRangeInSeconds);
        Date oldestDate = calendar.getTime();
        return this.jdbcTemplate.queryForInt("Select count(*) from COM_AUDIT_TRAIL where AUD_CLIENT_IP = ? and AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ?", new Object[]{request.getRemoteAddr(), userToUse, INSPEKTR_ACTION, this.applicationCode, oldestDate}, new int[]{12, 12, 12, 12, 93});
    }

    protected final void updateCount(HttpServletRequest request, String usernameParameter) {
        String userToUse = this.constructUsername(request, usernameParameter);
        AuditableActionContext context = new AuditableActionContext(userToUse, userToUse, INSPEKTR_ACTION, this.applicationCode, new Date(), request.getRemoteAddr(), request.getLocalAddr());
        this.auditTrailManager.record(context);
    }

    public final void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    protected String constructUsername(HttpServletRequest request, String usernameParameter) {
        String username = request.getParameter(usernameParameter);
        return "[username: " + (username != null ? username : "") + "]";
    }
}

