/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Arrays;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectMappingAuthenticationManagerImpl
extends AbstractAuthenticationManager {
    @NotNull
    @Size(min=1)
    private Map<Class<? extends Credentials>, DirectAuthenticationHandlerMappingHolder> credentialsMapping;

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        Class<?> credentialsClass = credentials.getClass();
        DirectAuthenticationHandlerMappingHolder d = this.credentialsMapping.get(credentialsClass);
        Assert.notNull((Object)d, (String)("no mapping found for: " + credentialsClass.getName()));
        if (!d.getAuthenticationHandler().authenticate(credentials)) {
            throw new BadCredentialsAuthenticationException();
        }
        Principal p = d.getCredentialsToPrincipalResolver().resolvePrincipal(credentials);
        return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(d.getAuthenticationHandler(), p);
    }

    public final void setCredentialsMapping(Map<Class<? extends Credentials>, DirectAuthenticationHandlerMappingHolder> credentialsMapping) {
        this.credentialsMapping = credentialsMapping;
    }

    public static final class DirectAuthenticationHandlerMappingHolder {
        private AuthenticationHandler authenticationHandler;
        private CredentialsToPrincipalResolver credentialsToPrincipalResolver;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public final AuthenticationHandler getAuthenticationHandler() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            return (AuthenticationHandler)DirectAuthenticationHandlerMappingHolder.getAuthenticationHandler_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void setAuthenticationHandler(AuthenticationHandler authenticationHandler) {
            this.authenticationHandler = authenticationHandler;
        }

        public CredentialsToPrincipalResolver getCredentialsToPrincipalResolver() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            return (CredentialsToPrincipalResolver)DirectAuthenticationHandlerMappingHolder.getCredentialsToPrincipalResolver_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void setCredentialsToPrincipalResolver(CredentialsToPrincipalResolver credentialsToPrincipalResolver) {
            this.credentialsToPrincipalResolver = credentialsToPrincipalResolver;
        }

        static {
            DirectAuthenticationHandlerMappingHolder.ajc$preClinit();
        }

        private static final /* synthetic */ Object getAuthenticationHandler_aroundBody1$advice(DirectAuthenticationHandlerMappingHolder ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            AuthenticationHandler authenticationHandler;
            AuthenticationHandler returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                authenticationHandler = returnVal = ajc$this.authenticationHandler;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return authenticationHandler;
        }

        private static final /* synthetic */ Object getCredentialsToPrincipalResolver_aroundBody3$advice(DirectAuthenticationHandlerMappingHolder ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            CredentialsToPrincipalResolver credentialsToPrincipalResolver;
            CredentialsToPrincipalResolver returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                credentialsToPrincipalResolver = returnVal = ajc$this.credentialsToPrincipalResolver;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return credentialsToPrincipalResolver;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("DirectMappingAuthenticationManagerImpl.java", DirectAuthenticationHandlerMappingHolder.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getAuthenticationHandler", "org.jasig.cas.authentication.DirectMappingAuthenticationManagerImpl$DirectAuthenticationHandlerMappingHolder", "", "", "", "org.jasig.cas.authentication.handler.AuthenticationHandler"), 70);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCredentialsToPrincipalResolver", "org.jasig.cas.authentication.DirectMappingAuthenticationManagerImpl$DirectAuthenticationHandlerMappingHolder", "", "", "", "org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver"), 79);
        }
    }
}

