/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    @NotNull
    private String realm = "CAS";

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    protected final boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        String transformedUsername = this.getPrincipalNameTransformer().transform(credentials.getUsername());
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempting authentication for: " + transformedUsername);
            }
            LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(transformedUsername, credentials.getPassword()));
            lc.login();
            lc.logout();
        }
        catch (LoginException loginException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authentication failed for: " + transformedUsername);
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication succeeded for: " + transformedUsername);
        }
        return true;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            Callback[] callbackArray = callbacks;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callbackArray);
            UsernamePasswordCallbackHandler.handle_aroundBody1$advice(this, callbackArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        static {
            UsernamePasswordCallbackHandler.ajc$preClinit();
        }

        private static final /* synthetic */ void handle_aroundBody0(UsernamePasswordCallbackHandler ajc$this, Callback[] callbacks, JoinPoint joinPoint) {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(ajc$this.userName);
                } else if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(ajc$this.password.toCharArray());
                } else {
                    throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
                }
                ++n2;
            }
        }

        private static final /* synthetic */ Object handle_aroundBody1$advice(UsernamePasswordCallbackHandler ajc$this, Callback[] callbacks, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Object object;
            Object returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                UsernamePasswordCallbackHandler.handle_aroundBody0(ajc$this, callbacks, (JoinPoint)proceedingJoinPoint2);
                object = returnVal = null;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return object;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JaasAuthenticationHandler.java", UsernamePasswordCallbackHandler.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "org.jasig.cas.authentication.handler.support.JaasAuthenticationHandler$UsernamePasswordCallbackHandler", "[Ljavax.security.auth.callback.Callback;", "callbacks", "javax.security.auth.callback.UnsupportedCallbackException", "void"), 123);
        }
    }
}

