/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationViaFormAction {
    private CredentialsBinder credentialsBinder;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private CookieGenerator warnCookieGenerator;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public final void doBind(RequestContext context, Credentials credentials) throws Exception {
        RequestContext requestContext = context;
        Credentials credentials2 = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)requestContext, (Object)credentials2);
        AuthenticationViaFormAction.doBind_aroundBody1$advice(this, requestContext, credentials2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final String submit(RequestContext context, Credentials credentials, MessageContext messageContext) throws Exception {
        RequestContext requestContext = context;
        Credentials credentials2 = credentials;
        MessageContext messageContext2 = messageContext;
        Object[] objectArray = new Object[]{requestContext, credentials2, messageContext2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        return (String)AuthenticationViaFormAction.submit_aroundBody3$advice(this, requestContext, credentials2, messageContext2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private void populateErrorsInstance(TicketException e, MessageContext messageContext) {
        try {
            messageContext.addMessage(new MessageBuilder().error().code(e.getCode()).defaultText(e.getCode()).build());
        }
        catch (Exception fe) {
            this.logger.error(fe.getMessage(), (Throwable)fe);
        }
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse(context);
        if (StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("warn"))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    static {
        AuthenticationViaFormAction.ajc$preClinit();
    }

    private static final /* synthetic */ void doBind_aroundBody0(AuthenticationViaFormAction ajc$this, RequestContext context, Credentials credentials, JoinPoint joinPoint) {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        if (ajc$this.credentialsBinder != null && ajc$this.credentialsBinder.supports(credentials.getClass())) {
            ajc$this.credentialsBinder.bind(request, credentials);
        }
    }

    private static final /* synthetic */ Object doBind_aroundBody1$advice(AuthenticationViaFormAction ajc$this, RequestContext context, Credentials credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            AuthenticationViaFormAction.doBind_aroundBody0(ajc$this, context, credentials, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ String submit_aroundBody2(AuthenticationViaFormAction ajc$this, RequestContext context, Credentials credentials, MessageContext messageContext, JoinPoint joinPoint) {
        block7: {
            String providedLoginTicket;
            String authoritativeLoginTicket = WebUtils.getLoginTicketFromFlowScope(context);
            if (!authoritativeLoginTicket.equals(providedLoginTicket = WebUtils.getLoginTicketFromRequest(context))) {
                ajc$this.logger.warn("Invalid login ticket " + providedLoginTicket);
                messageContext.addMessage(new MessageBuilder().error().code("INVALID_TICKET").arg((Object)providedLoginTicket).defaultText("INVALID_TICKET").build());
                return "error";
            }
            String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
            WebApplicationService service = WebUtils.getService(context);
            if (StringUtils.hasText((String)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null) {
                try {
                    String serviceTicketId = ajc$this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credentials);
                    WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                    ajc$this.putWarnCookieIfRequestParameterPresent(context);
                    return "warn";
                }
                catch (TicketException e) {
                    if (e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass())) {
                        ajc$this.populateErrorsInstance(e, messageContext);
                        return "error";
                    }
                    ajc$this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                    if (!ajc$this.logger.isDebugEnabled()) break block7;
                    ajc$this.logger.debug("Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            WebUtils.putTicketGrantingTicketInRequestScope(context, ajc$this.centralAuthenticationService.createTicketGrantingTicket(credentials));
            ajc$this.putWarnCookieIfRequestParameterPresent(context);
            return "success";
        }
        catch (TicketException e) {
            ajc$this.populateErrorsInstance(e, messageContext);
            return "error";
        }
    }

    private static final /* synthetic */ Object submit_aroundBody3$advice(AuthenticationViaFormAction ajc$this, RequestContext context, Credentials credentials, MessageContext messageContext, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = AuthenticationViaFormAction.submit_aroundBody2(ajc$this, context, credentials, messageContext, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuthenticationViaFormAction.java", AuthenticationViaFormAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "doBind", "org.jasig.cas.web.flow.AuthenticationViaFormAction", "org.springframework.webflow.execution.RequestContext:org.jasig.cas.authentication.principal.Credentials", "context:credentials", "java.lang.Exception", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "submit", "org.jasig.cas.web.flow.AuthenticationViaFormAction", "org.springframework.webflow.execution.RequestContext:org.jasig.cas.authentication.principal.Credentials:org.springframework.binding.message.MessageContext", "context:credentials:messageContext", "java.lang.Exception", "java.lang.String"), 61);
    }
}

