/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.github.inspektr.audit.annotation.Audit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertionImpl;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private TicketRegistry serviceTicketRegistry;
    @NotNull
    private AuthenticationManager authenticationManager;
    @NotNull
    private UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    private Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @NotNull
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    @NotNull
    private ExpirationPolicy serviceTicketExpirationPolicy;
    @NotNull
    private ServicesManager servicesManager;
    @NotNull
    private PersistentIdGenerator persistentIdGenerator = new ShibbolethCompatiblePersistentIdGenerator();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Override
    @Audit(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="DESTROY_TICKET_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public void destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        String string = ticketGrantingTicketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        CentralAuthenticationServiceImpl.destroyTicketGrantingTicket_aroundBody1$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credentials credentials) throws TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        Credentials credentials2 = credentials;
        Object[] objectArray = new Object[]{string, service2, credentials2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        return (String)CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody3$advice(this, string, service2, credentials2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        String string = ticketGrantingTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)service2);
        return (String)CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody5$advice(this, string, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="GRANT_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="GRANT_PROXY_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String delegateTicketGrantingTicket(String serviceTicketId, Credentials credentials) throws TicketException {
        String string = serviceTicketId;
        Credentials credentials2 = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)credentials2);
        return (String)CentralAuthenticationServiceImpl.delegateTicketGrantingTicket_aroundBody7$advice(this, string, credentials2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="VALIDATE_SERVICE_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        String string = serviceTicketId;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)service2);
        return (Assertion)CentralAuthenticationServiceImpl.validateServiceTicket_aroundBody9$advice(this, string, service2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Override
    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Profiled(tag="CREATE_TICKET_GRANTING_TICKET", logFailuresSeparately=false)
    @Transactional(readOnly=false)
    public String createTicketGrantingTicket(Credentials credentials) throws TicketCreationException {
        Credentials credentials2 = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)credentials2);
        return (String)CentralAuthenticationServiceImpl.createTicketGrantingTicket_aroundBody11$advice(this, credentials2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
        if (this.serviceTicketRegistry == null) {
            this.serviceTicketRegistry = ticketRegistry;
        }
    }

    public void setServiceTicketRegistry(TicketRegistry serviceTicketRegistry) {
        this.serviceTicketRegistry = serviceTicketRegistry;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setTicketGrantingTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    public void setUniqueTicketIdGeneratorsForService(Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService) {
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }

    static {
        Factory factory = new Factory("CentralAuthenticationServiceImpl.java", Class.forName("org.jasig.cas.CentralAuthenticationServiceImpl"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroyTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:", "ticketGrantingTicketId:", "", "void"), 137);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:org.jasig.cas.authentication.principal.Credentials:", "ticketGrantingTicketId:service:credentials:", "org.jasig.cas.ticket.TicketException:", "java.lang.String"), 166);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "grantServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:", "ticketGrantingTicketId:service:", "org.jasig.cas.ticket.TicketException:", "java.lang.String"), 249);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delegateTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Credentials:", "serviceTicketId:credentials:", "org.jasig.cas.ticket.TicketException:", "java.lang.String"), 264);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateServiceTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "java.lang.String:org.jasig.cas.authentication.principal.Service:", "serviceTicketId:service:", "org.jasig.cas.ticket.TicketException:", "org.jasig.cas.validation.Assertion"), 314);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTicketGrantingTicket", "org.jasig.cas.CentralAuthenticationServiceImpl", "org.jasig.cas.authentication.principal.Credentials:", "credentials:", "org.jasig.cas.ticket.TicketCreationException:", "java.lang.String"), 408);
    }

    private static final /* synthetic */ void destroyTicketGrantingTicket_aroundBody0(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, JoinPoint joinPoint) {
        TicketGrantingTicket ticket;
        Assert.notNull((Object)ticketGrantingTicketId);
        if (ajc$this.log.isDebugEnabled()) {
            ajc$this.log.debug("Removing ticket [" + ticketGrantingTicketId + "] from registry.");
        }
        if ((ticket = (TicketGrantingTicket)ajc$this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class)) == null) {
            return;
        }
        if (ajc$this.log.isDebugEnabled()) {
            ajc$this.log.debug("Ticket found.  Expiring and then deleting.");
        }
        ticket.expire();
        ajc$this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
    }

    private static final /* synthetic */ Object destroyTicketGrantingTicket_aroundBody1$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            CentralAuthenticationServiceImpl.destroyTicketGrantingTicket_aroundBody0(ajc$this, ticketGrantingTicketId, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ String grantServiceTicket_aroundBody2(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, Credentials credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)ticketGrantingTicketId, (String)"ticketGrantingticketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ajc$this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        if (ticketGrantingTicket == null) {
            throw new InvalidTicketException();
        }
        TicketGrantingTicket ticketGrantingTicket2 = ticketGrantingTicket;
        synchronized (ticketGrantingTicket2) {
            if (ticketGrantingTicket.isExpired()) {
                ajc$this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
                throw new InvalidTicketException();
            }
        }
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.isEnabled()) {
            ajc$this.log.warn("ServiceManagement: Unauthorized Service Access. Service [" + service.getId() + "] not found in Service Registry.");
            throw new UnauthorizedServiceException();
        }
        if (!registeredService.isSsoEnabled() && credentials == null && ticketGrantingTicket.getCountOfUses() > 0) {
            ajc$this.log.warn("ServiceManagement: Service Not Allowed to use SSO.  Service [" + service.getId() + "]");
            throw new UnauthorizedSsoServiceException();
        }
        if (credentials != null) {
            try {
                Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
                Authentication originalAuthentication = ticketGrantingTicket.getAuthentication();
                if (!authentication.getPrincipal().equals(originalAuthentication.getPrincipal()) || !authentication.getAttributes().equals(originalAuthentication.getAttributes())) {
                    throw new TicketCreationException();
                }
            }
            catch (AuthenticationException e) {
                throw new TicketCreationException(e);
            }
        }
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = ajc$this.uniqueTicketIdGeneratorsForService.get(service.getClass().getName());
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST"), service, ajc$this.serviceTicketExpirationPolicy, credentials != null);
        ajc$this.serviceTicketRegistry.addTicket(serviceTicket);
        if (ajc$this.log.isInfoEnabled()) {
            List<Authentication> authentications = serviceTicket.getGrantingTicket().getChainedAuthentications();
            String principalId = authentications.get(authentications.size() - 1).getPrincipal().getId();
            String type = authentications.size() == 1 ? "service" : "proxy";
            ajc$this.log.info(String.format("Granted %s ticket [%s] for service [%s] for user [%s]", type, serviceTicket.getId(), service.getId(), principalId));
        }
        return serviceTicket.getId();
    }

    private static final /* synthetic */ Object grantServiceTicket_aroundBody3$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, Credentials credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = CentralAuthenticationServiceImpl.grantServiceTicket_aroundBody2(ajc$this, ticketGrantingTicketId, service, credentials, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ Object grantServiceTicket_aroundBody5$advice(CentralAuthenticationServiceImpl ajc$this, String ticketGrantingTicketId, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = ajc$this.grantServiceTicket(ticketGrantingTicketId, service, null);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static final /* synthetic */ String delegateTicketGrantingTicket_aroundBody6(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Credentials credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        try {
            Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
            ServiceTicket serviceTicket = (ServiceTicket)ajc$this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
            if (serviceTicket == null || serviceTicket.isExpired()) {
                throw new InvalidTicketException();
            }
            RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(serviceTicket.getService());
            if (registeredService == null || !registeredService.isEnabled() || !registeredService.isAllowedToProxy()) {
                ajc$this.log.warn("ServiceManagement: Service Attempted to Proxy, but is not allowed.  Service: [" + serviceTicket.getService().getId() + "]");
                throw new UnauthorizedProxyingException();
            }
            TicketGrantingTicket ticketGrantingTicket = serviceTicket.grantTicketGrantingTicket(ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
            ajc$this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    private static final /* synthetic */ Object delegateTicketGrantingTicket_aroundBody7$advice(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Credentials credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = CentralAuthenticationServiceImpl.delegateTicketGrantingTicket_aroundBody6(ajc$this, serviceTicketId, credentials, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Assertion validateServiceTicket_aroundBody8(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Service service, JoinPoint joinPoint) {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        ServiceTicket serviceTicket = (ServiceTicket)ajc$this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.isEnabled()) {
            ajc$this.log.warn("ServiceManagement: Service does not exist is not enabled, and thus not allowed to validate tickets.   Service: [" + service.getId() + "]");
            throw new UnauthorizedServiceException("Service not allowed to validate tickets.");
        }
        if (serviceTicket == null) {
            ajc$this.log.info("ServiceTicket [" + serviceTicketId + "] does not exist.");
            throw new InvalidTicketException();
        }
        try {
            Authentication authToUse;
            String principalId;
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    ajc$this.log.info("ServiceTicket [" + serviceTicketId + "] has expired.");
                    throw new InvalidTicketException();
                }
                if (!serviceTicket.isValidFor(service)) {
                    ajc$this.log.error("ServiceTicket [" + serviceTicketId + "] with service [" + serviceTicket.getService().getId() + " does not match supplied service [" + service + "]");
                    throw new TicketValidationException(serviceTicket.getService());
                }
            }
            int authenticationChainSize = serviceTicket.getGrantingTicket().getChainedAuthentications().size();
            Authentication authentication = serviceTicket.getGrantingTicket().getChainedAuthentications().get(authenticationChainSize - 1);
            Principal principal = authentication.getPrincipal();
            String string = principalId = registeredService.isAnonymousAccess() ? ajc$this.persistentIdGenerator.generate(principal, serviceTicket.getService()) : principal.getId();
            if (!registeredService.isIgnoreAttributes()) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                for (String attribute : registeredService.getAllowedAttributes()) {
                    Object value = principal.getAttributes().get(attribute);
                    if (value == null) continue;
                    attributes.put(attribute, value);
                }
                SimplePrincipal modifiedPrincipal = new SimplePrincipal(principalId, attributes);
                MutableAuthentication mutableAuthentication = new MutableAuthentication((Principal)modifiedPrincipal, authentication.getAuthenticatedDate());
                mutableAuthentication.getAttributes().putAll(authentication.getAttributes());
                mutableAuthentication.getAuthenticatedDate().setTime(authentication.getAuthenticatedDate().getTime());
                authToUse = mutableAuthentication;
            } else {
                authToUse = authentication;
            }
            ArrayList<Authentication> authentications = new ArrayList<Authentication>();
            int i = 0;
            while (i < authenticationChainSize - 1) {
                authentications.add(serviceTicket.getGrantingTicket().getChainedAuthentications().get(i));
                ++i;
            }
            authentications.add(authToUse);
            ImmutableAssertionImpl immutableAssertionImpl = new ImmutableAssertionImpl(authentications, serviceTicket.getService(), serviceTicket.isFromNewLogin());
            return immutableAssertionImpl;
        }
        finally {
            if (serviceTicket.isExpired()) {
                ajc$this.serviceTicketRegistry.deleteTicket(serviceTicketId);
            }
        }
    }

    private static final /* synthetic */ Object validateServiceTicket_aroundBody9$advice(CentralAuthenticationServiceImpl ajc$this, String serviceTicketId, Service service, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Assertion assertion;
        Assertion returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            assertion = returnVal = CentralAuthenticationServiceImpl.validateServiceTicket_aroundBody8(ajc$this, serviceTicketId, service, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return assertion;
    }

    private static final /* synthetic */ String createTicketGrantingTicket_aroundBody10(CentralAuthenticationServiceImpl ajc$this, Credentials credentials, JoinPoint joinPoint) {
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        try {
            Authentication authentication = ajc$this.authenticationManager.authenticate(credentials);
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(ajc$this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, ajc$this.ticketGrantingTicketExpirationPolicy);
            ajc$this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    private static final /* synthetic */ Object createTicketGrantingTicket_aroundBody11$advice(CentralAuthenticationServiceImpl ajc$this, Credentials credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = CentralAuthenticationServiceImpl.createTicketGrantingTicket_aroundBody10(ajc$this, credentials, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }
}

