/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.authentication.AbstractAuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationManagerImpl
extends AbstractAuthenticationManager {
    @NotNull
    @Size(min=1)
    private List<AuthenticationHandler> authenticationHandlers;
    @NotNull
    @Size(min=1)
    private List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers;

    @Override
    protected AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials credentials) throws AuthenticationException {
        boolean foundSupported = false;
        boolean authenticated = false;
        AuthenticationHandler authenticatedClass = null;
        for (AuthenticationHandler authenticationHandler : this.authenticationHandlers) {
            if (!authenticationHandler.supports(credentials)) continue;
            foundSupported = true;
            if (!authenticationHandler.authenticate(credentials)) {
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("AuthenticationHandler: " + authenticationHandler.getClass().getName() + " failed to authenticate the user which provided the following credentials: " + credentials.toString());
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("AuthenticationHandler: " + authenticationHandler.getClass().getName() + " successfully authenticated the user which provided the following credentials: " + credentials.toString());
            }
            authenticatedClass = authenticationHandler;
            authenticated = true;
            break;
        }
        if (!authenticated) {
            if (foundSupported) {
                throw BadCredentialsAuthenticationException.ERROR;
            }
            throw UnsupportedCredentialsException.ERROR;
        }
        foundSupported = false;
        for (CredentialsToPrincipalResolver credentialsToPrincipalResolver : this.credentialsToPrincipalResolvers) {
            if (!credentialsToPrincipalResolver.supports(credentials)) continue;
            Principal principal = credentialsToPrincipalResolver.resolvePrincipal(credentials);
            foundSupported = true;
            if (principal == null) continue;
            return new AbstractAuthenticationManager.Pair<AuthenticationHandler, Principal>(authenticatedClass, principal);
        }
        if (foundSupported) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("CredentialsToPrincipalResolver found but no principal returned.");
            }
            throw BadCredentialsAuthenticationException.ERROR;
        }
        this.log.error("CredentialsToPrincipalResolver not found for " + credentials.getClass().getName());
        throw UnsupportedCredentialsException.ERROR;
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public void setCredentialsToPrincipalResolvers(List<CredentialsToPrincipalResolver> credentialsToPrincipalResolvers) {
        this.credentialsToPrincipalResolvers = credentialsToPrincipalResolvers;
    }
}

