/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.perf4j.log4j.GraphingStatisticsAppender;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatisticsController
extends AbstractController {
    private static final int NUMBER_OF_MILLISECONDS_IN_A_DAY = 86400000;
    private static final int NUMBER_OF_MILLISECONDS_IN_AN_HOUR = 3600000;
    private static final int NUMBER_OF_MILLISECONDS_IN_A_MINUTE = 60000;
    private static final int NUMBER_OF_MILLISECONDS_IN_A_SECOND = 1000;
    private final TicketRegistry ticketRegistry;
    private final Date upTimeStartDate = new Date();
    private String casTicketSuffix;

    public StatisticsController(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setCasTicketSuffix(String casTicketSuffix) {
        this.casTicketSuffix = casTicketSuffix;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ModelAndView modelAndView = new ModelAndView("viewStatisticsView");
        modelAndView.addObject("startTime", (Object)this.upTimeStartDate);
        double difference = System.currentTimeMillis() - this.upTimeStartDate.getTime();
        modelAndView.addObject("upTime", (Object)this.calculateUptime(difference, new LinkedList<Integer>((Collection)Arrays.asList(86400000, 3600000, 60000, 1000, 1)), new LinkedList<String>((Collection)Arrays.asList("day", "hour", "minute", "second", "millisecond"))));
        modelAndView.addObject("totalMemory", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        modelAndView.addObject("maxMemory", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        modelAndView.addObject("freeMemory", (Object)(Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        modelAndView.addObject("availableProcessors", (Object)Runtime.getRuntime().availableProcessors());
        modelAndView.addObject("serverHostName", (Object)httpServletRequest.getServerName());
        modelAndView.addObject("serverIpAddress", (Object)httpServletRequest.getLocalAddr());
        modelAndView.addObject("casTicketSuffix", (Object)this.casTicketSuffix);
        int unexpiredTgts = 0;
        int unexpiredSts = 0;
        int expiredTgts = 0;
        int expiredSts = 0;
        try {
            Collection<Ticket> tickets = this.ticketRegistry.getTickets();
            for (Ticket ticket : tickets) {
                if (ticket instanceof ServiceTicket) {
                    if (ticket.isExpired()) {
                        ++expiredSts;
                        continue;
                    }
                    ++unexpiredSts;
                    continue;
                }
                if (ticket.isExpired()) {
                    ++expiredTgts;
                    continue;
                }
                ++unexpiredTgts;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        Collection appenders = GraphingStatisticsAppender.getAllGraphingStatisticsAppenders();
        modelAndView.addObject("unexpiredTgts", (Object)unexpiredTgts);
        modelAndView.addObject("unexpiredSts", (Object)unexpiredSts);
        modelAndView.addObject("expiredTgts", (Object)expiredTgts);
        modelAndView.addObject("expiredSts", (Object)expiredSts);
        modelAndView.addObject("pageTitle", (Object)modelAndView.getViewName());
        modelAndView.addObject("graphingStatisticAppenders", (Object)appenders);
        return modelAndView;
    }

    protected String calculateUptime(double difference, Queue<Integer> calculations, Queue<String> labels) {
        if (calculations.isEmpty()) {
            return "";
        }
        int value = calculations.remove();
        double time = Math.floor(difference / (double)value);
        double newDifference = difference - time * (double)value;
        String currentLabel = labels.remove();
        String label = time == 0.0 || time > 1.0 ? String.valueOf(currentLabel) + "s" : currentLabel;
        return String.valueOf(Integer.toString(new Double(time).intValue())) + " " + label + " " + this.calculateUptime(newDifference, calculations, labels);
    }
}

