/*
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.cas.monitor;

/**
 * A monitor observes a resource and reports its status.
 *
 * @author Marvin S. Addison
 * @version $Revision: $
 */
public interface Monitor<S extends Status> {

    /**
     * Gets the name of the monitor.
     *
     * @return Monitor name.
     */
    String getName();


    /**
     * Observes the monitored resource and reports the status.
     *
     * @return Status of monitored resource.
     */
    S observe();
}
