/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServicesManagerMBean<T extends ServicesManager> {
    @NotNull
    private T servicesManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected AbstractServicesManagerMBean(T servicesManager) {
        this.servicesManager = servicesManager;
    }

    protected final T getServicesManager() {
        return this.servicesManager;
    }

    @ManagedAttribute(description="Retrieves the list of Registered Services in a slightly friendlier output.")
    public final List<String> getRegisteredServicesAsStrings() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (List)AbstractServicesManagerMBean.getRegisteredServicesAsStrings_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ManagedOperation(description="Can remove a service based on its identifier.")
    @ManagedOperationParameter(name="id", description="the identifier to remove")
    public final RegisteredService removeService(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        return (RegisteredService)AbstractServicesManagerMBean.removeService_aroundBody3$advice(this, l, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ManagedOperation(description="Disable a service by id.")
    @ManagedOperationParameter(name="id", description="the identifier to disable")
    public final void disableService(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        AbstractServicesManagerMBean.disableService_aroundBody5$advice(this, l, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ManagedOperation(description="Enable a service by its id.")
    @ManagedOperationParameter(name="id", description="the identifier to enable.")
    public final void enableService(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        AbstractServicesManagerMBean.enableService_aroundBody7$advice(this, l, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private void changeEnabledState(long id, boolean newState) {
        RegisteredService r = this.servicesManager.findServiceBy(id);
        Assert.notNull((Object)r, (String)"invalid RegisteredService id");
        ((RegisteredServiceImpl)r).setEnabled(newState);
        this.servicesManager.save(r);
    }

    static {
        AbstractServicesManagerMBean.ajc$preClinit();
    }

    private static final /* synthetic */ List getRegisteredServicesAsStrings_aroundBody0(AbstractServicesManagerMBean ajc$this, JoinPoint joinPoint) {
        ArrayList<String> services = new ArrayList<String>();
        for (RegisteredService r : ajc$this.servicesManager.getAllServices()) {
            services.add("id: " + r.getId() + " name: " + r.getName() + " enabled: " + r.isEnabled() + " ssoEnabled: " + r.isSsoEnabled() + " serviceId: " + r.getServiceId());
        }
        return services;
    }

    private static final /* synthetic */ Object getRegisteredServicesAsStrings_aroundBody1$advice(AbstractServicesManagerMBean ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        List list;
        List returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            list = returnVal = AbstractServicesManagerMBean.getRegisteredServicesAsStrings_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return list;
    }

    private static final /* synthetic */ Object removeService_aroundBody3$advice(AbstractServicesManagerMBean ajc$this, long id, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        RegisteredService registeredService;
        RegisteredService returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            registeredService = returnVal = ajc$this.servicesManager.delete(id);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return registeredService;
    }

    private static final /* synthetic */ Object disableService_aroundBody5$advice(AbstractServicesManagerMBean ajc$this, long id, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ajc$this.changeEnabledState(id, false);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ Object enableService_aroundBody7$advice(AbstractServicesManagerMBean ajc$this, long id, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ajc$this.changeEnabledState(id, true);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractServicesManagerMBean.java", AbstractServicesManagerMBean.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getRegisteredServicesAsStrings", "org.jasig.cas.services.jmx.AbstractServicesManagerMBean", "", "", "", "java.util.List"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "removeService", "org.jasig.cas.services.jmx.AbstractServicesManagerMBean", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 74);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "disableService", "org.jasig.cas.services.jmx.AbstractServicesManagerMBean", "long", "id", "", "void"), 80);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "enableService", "org.jasig.cas.services.jmx.AbstractServicesManagerMBean", "long", "id", "", "void"), 86);
    }
}

