/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.HealthCheckMonitor;
import org.jasig.cas.monitor.HealthStatus;
import org.jasig.cas.monitor.Status;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class HealthCheckController
extends AbstractController {
    private static final String HEADER_PREFIX = "X-CAS-";
    @NotNull
    private HealthCheckMonitor healthCheckMonitor;

    public void setHealthCheckMonitor(HealthCheckMonitor monitor) {
        this.healthCheckMonitor = monitor;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HealthStatus healthStatus = this.healthCheckMonitor.observe();
        StringBuilder sb = new StringBuilder();
        sb.append("Health: ").append((Object)healthStatus.getCode());
        int i = 0;
        for (Map.Entry<String, Status> entry : healthStatus.getDetails().entrySet()) {
            String name = entry.getKey();
            Status status = entry.getValue();
            response.addHeader(HEADER_PREFIX + name, String.format("%s;%s", new Object[]{status.getCode(), status.getDescription()}));
            sb.append("\n\n\t").append(++i).append('.').append(name).append(": ");
            sb.append((Object)status.getCode());
            if (status.getDescription() == null) continue;
            sb.append(" - ").append(status.getDescription());
        }
        response.setStatus(healthStatus.getCode().value());
        response.setContentType("text/plain");
        response.getOutputStream().write(sb.toString().getBytes(response.getCharacterEncoding()));
        return null;
    }
}

