/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.NoOpPrincipalNameTransformer;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.jasig.cas.authentication.handler.PlainTextPasswordEncoder;
import org.jasig.cas.authentication.handler.PrincipalNameTransformer;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;

public abstract class AbstractUsernamePasswordAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @NotNull
    private PasswordEncoder passwordEncoder = new PlainTextPasswordEncoder();
    @NotNull
    private PrincipalNameTransformer principalNameTransformer = new NoOpPrincipalNameTransformer();

    @Override
    protected final HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        UsernamePasswordCredential userPass = (UsernamePasswordCredential)credential;
        if (userPass.getUsername() == null) {
            throw new AccountNotFoundException("Username is null.");
        }
        String transformedUsername = this.principalNameTransformer.transform(userPass.getUsername());
        if (transformedUsername == null) {
            throw new AccountNotFoundException("Transformed username is null.");
        }
        Principal principal = this.authenticateUsernamePasswordInternal(transformedUsername, userPass.getPassword());
        return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), principal);
    }

    protected abstract Principal authenticateUsernamePasswordInternal(String var1, String var2) throws GeneralSecurityException, PreventedException;

    protected final PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    protected final PrincipalNameTransformer getPrincipalNameTransformer() {
        return this.principalNameTransformer;
    }

    public final void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public final void setPrincipalNameTransformer(PrincipalNameTransformer principalNameTransformer) {
        this.principalNameTransformer = principalNameTransformer;
    }

    @Override
    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }
}

