/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    @NotNull
    private String realm = "CAS";

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Principal authenticateUsernamePasswordInternal(String username, String password) throws GeneralSecurityException, PreventedException {
        LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(username, password));
        try {
            this.logger.debug("Attempting authentication for: {}", (Object)username);
            lc.login();
        }
        finally {
            lc.logout();
        }
        SimplePrincipal principal = null;
        Set<java.security.Principal> principals = lc.getSubject().getPrincipals();
        if (principals != null && principals.size() > 0) {
            principal = new SimplePrincipal(principals.iterator().next().getName());
        }
        return principal;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(this.userName);
                    continue;
                }
                if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }
}

