/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import org.jasig.cas.authentication.principal.Response;
import org.junit.Assert;
import org.junit.Test;

public class ResponseTests {
    @Test
    public void testConstructionWithoutFragmentAndNoQueryString() {
        String url = "http://localhost:8080/foo";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "foobar");
        Response response = Response.getRedirectResponse((String)"http://localhost:8080/foo", attributes);
        Assert.assertEquals((Object)"http://localhost:8080/foo?ticket=foobar", (Object)response.getUrl());
    }

    @Test
    public void testConstructionWithoutFragmentButHasQueryString() {
        String url = "http://localhost:8080/foo?test=boo";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "foobar");
        Response response = Response.getRedirectResponse((String)"http://localhost:8080/foo?test=boo", attributes);
        Assert.assertEquals((Object)"http://localhost:8080/foo?test=boo&ticket=foobar", (Object)response.getUrl());
    }

    @Test
    public void testConstructionWithFragmentAndQueryString() {
        String url = "http://localhost:8080/foo?test=boo#hello";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "foobar");
        Response response = Response.getRedirectResponse((String)"http://localhost:8080/foo?test=boo#hello", attributes);
        Assert.assertEquals((Object)"http://localhost:8080/foo?test=boo&ticket=foobar#hello", (Object)response.getUrl());
    }

    @Test
    public void testConstructionWithFragmentAndNoQueryString() {
        String url = "http://localhost:8080/foo#hello";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "foobar");
        Response response = Response.getRedirectResponse((String)"http://localhost:8080/foo#hello", attributes);
        Assert.assertEquals((Object)"http://localhost:8080/foo?ticket=foobar#hello", (Object)response.getUrl());
    }

    @Test
    public void testUrlSanitization() {
        String url = "https://www.example.com\r\nLocation: javascript:\r\n\r\n<script>alert(document.cookie)</script>";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "ST-12345");
        Response response = Response.getRedirectResponse((String)"https://www.example.com\r\nLocation: javascript:\r\n\r\n<script>alert(document.cookie)</script>", attributes);
        Assert.assertEquals((Object)"https://www.example.com Location: javascript: <script>alert(document.cookie)</script>?ticket=ST-12345", (Object)response.getUrl());
    }

    @Test
    public void testUrlWithUnicode() {
        String url = "https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ticket", "ST-12345");
        Response response = Response.getRedirectResponse((String)"https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd", attributes);
        Assert.assertEquals((Object)"https://www.example.com/\u03c0\u03bf\u03bb\u03b9\u03c4\u03b9\u03ba\u1ff6\u03bd?ticket=ST-12345", (Object)response.getUrl());
    }
}

