/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.mock;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.mock.MockServiceTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public class MockTicketGrantingTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = 6546995681334670659L;
    public static final UniqueTicketIdGenerator ID_GENERATOR = new DefaultUniqueTicketIdGenerator();
    private final String id = ID_GENERATOR.getNewTicketId("TGT");
    private final Authentication authentication;
    private final Date created;
    private int usageCount;
    private boolean expired;

    public MockTicketGrantingTicket(String principal) {
        this.authentication = new AuthenticationBuilder((Principal)new SimplePrincipal(principal)).build();
        this.created = new Date();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ServiceTicket grantServiceTicket(Service service) {
        return this.grantServiceTicket(ID_GENERATOR.getNewTicketId("ST"), service, null, true);
    }

    public ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        ++this.usageCount;
        return new MockServiceTicket(id, service, this);
    }

    public boolean isRoot() {
        return true;
    }

    public TicketGrantingTicket getRoot() {
        return this;
    }

    public List<Authentication> getSupplementalAuthentications() {
        return Collections.emptyList();
    }

    public List<Authentication> getChainedAuthentications() {
        return Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public TicketGrantingTicket getGrantingTicket() {
        return this;
    }

    public long getCreationTime() {
        return this.created.getTime();
    }

    public int getCountOfUses() {
        return this.usageCount;
    }

    public Map<String, Service> getServices() {
        return Collections.emptyMap();
    }

    public void removeAllServices() {
    }

    public void markTicketExpired() {
        this.expired = true;
    }
}

