/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.TicketGrantingTicketExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TicketGrantingTicketExpirationPolicyTests {
    private static final long HARD_TIMEOUT = 100L;
    private static final long SLIDING_TIMEOUT = 60L;
    private static final long TIMEOUT_BUFFER = 20L;
    private TicketGrantingTicketExpirationPolicy expirationPolicy;
    private TicketGrantingTicket ticketGrantingTicket;

    @Before
    public void setUp() throws Exception {
        this.expirationPolicy = new TicketGrantingTicketExpirationPolicy();
        this.expirationPolicy.setMaxTimeToLiveInMilliSeconds(100L);
        this.expirationPolicy.setTimeToKillInMilliSeconds(60L);
        this.ticketGrantingTicket = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)this.expirationPolicy);
    }

    @Test
    public void testTgtIsExpiredByHardTimeOut() throws InterruptedException {
        while (System.currentTimeMillis() - this.ticketGrantingTicket.getCreationTime() < 70L) {
            this.ticketGrantingTicket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
            Thread.sleep(40L);
            Assert.assertFalse((boolean)this.ticketGrantingTicket.isExpired());
        }
        this.ticketGrantingTicket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Thread.sleep(50L);
        Assert.assertTrue((boolean)this.ticketGrantingTicket.isExpired());
    }

    @Test
    public void testTgtIsExpiredBySlidingWindow() throws InterruptedException {
        this.ticketGrantingTicket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Thread.sleep(40L);
        Assert.assertFalse((boolean)this.ticketGrantingTicket.isExpired());
        this.ticketGrantingTicket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Thread.sleep(40L);
        Assert.assertFalse((boolean)this.ticketGrantingTicket.isExpired());
        this.ticketGrantingTicket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Thread.sleep(80L);
        Assert.assertTrue((boolean)this.ticketGrantingTicket.isExpired());
    }
}

