/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.cas.Message;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HandlerResult
implements Serializable {
    private static final long serialVersionUID = -3113998493287982485L;
    private String handlerName;
    private CredentialMetaData credentialMetaData;
    private Principal principal;
    private List<Message> warnings;

    private HandlerResult() {
    }

    public HandlerResult(AuthenticationHandler source, CredentialMetaData metaData) {
        this(source, metaData, null, null);
    }

    public HandlerResult(AuthenticationHandler source, CredentialMetaData metaData, Principal p) {
        this(source, metaData, p, null);
    }

    public HandlerResult(AuthenticationHandler source, CredentialMetaData metaData, List<Message> warnings) {
        this(source, metaData, null, null);
    }

    public HandlerResult(AuthenticationHandler source, CredentialMetaData metaData, Principal p, List<Message> warnings) {
        Assert.notNull((Object)source, (String)"Source cannot be null.");
        Assert.notNull((Object)metaData, (String)"Credential metadata cannot be null.");
        this.handlerName = source.getName();
        if (!StringUtils.hasText((String)this.handlerName)) {
            this.handlerName = source.getClass().getSimpleName();
        }
        this.credentialMetaData = metaData;
        this.principal = p;
        this.warnings = warnings;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public CredentialMetaData getCredentialMetaData() {
        return this.credentialMetaData;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public List<Message> getWarnings() {
        return this.warnings == null ? Collections.emptyList() : Collections.unmodifiableList(this.warnings);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(109, 31);
        builder.append((Object)this.handlerName);
        builder.append((Object)this.credentialMetaData);
        builder.append((Object)this.principal);
        builder.append(this.warnings);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HandlerResult)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HandlerResult other = (HandlerResult)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.handlerName, (Object)other.handlerName);
        builder.append((Object)this.credentialMetaData, (Object)other.credentialMetaData);
        builder.append((Object)this.principal, (Object)other.principal);
        builder.append(this.warnings, other.warnings);
        return builder.isEquals();
    }

    public String toString() {
        return this.handlerName + ":" + this.credentialMetaData;
    }
}

