/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public final class SimpleHttpClient
implements HttpClient,
Serializable,
DisposableBean {
    private static final long serialVersionUID = -5306738686476129516L;
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(100);
    @NotNull
    @Size(min=1)
    private int[] acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
    @Min(value=0L)
    private int connectionTimeout = 5000;
    @Min(value=0L)
    private int readTimeout = 5000;
    private boolean followRedirects = true;
    private SSLSocketFactory sslSocketFactory = null;
    private HostnameVerifier hostnameVerifier = null;

    public void setExecutorService(@NotNull ExecutorService executorService) {
        Assert.notNull((Object)executorService);
        EXECUTOR_SERVICE = executorService;
    }

    @Override
    public boolean sendMessageToEndPoint(String url, String message, boolean async) {
        Future<Boolean> result = EXECUTOR_SERVICE.submit(new MessageSender(url, message, this.readTimeout, this.connectionTimeout, this.followRedirects));
        if (async) {
            return true;
        }
        try {
            return result.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isValidEndPoint(String url) {
        try {
            URL u = new URL(url);
            return this.isValidEndPoint(u);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidEndPoint(URL url) {
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setInstanceFollowRedirects(this.followRedirects);
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                if (this.sslSocketFactory != null) {
                    httpsConnection.setSSLSocketFactory(this.sslSocketFactory);
                }
                if (this.hostnameVerifier != null) {
                    httpsConnection.setHostnameVerifier(this.hostnameVerifier);
                }
            }
            connection.connect();
            int responseCode = connection.getResponseCode();
            for (int acceptableCode : this.acceptableCodes) {
                if (responseCode != acceptableCode) continue;
                LOGGER.debug("Response code from server matched {}.", (Object)responseCode);
                boolean bl = true;
                IOUtils.closeQuietly((InputStream)is);
                if (connection != null) {
                    connection.disconnect();
                }
                return bl;
            }
            LOGGER.debug("Response Code did not match any of the acceptable response codes. Code returned was {}", (Object)responseCode);
            if (responseCode == 500) {
                is = connection.getInputStream();
                String value = IOUtils.toString((InputStream)is);
                LOGGER.error("There was an error contacting the endpoint: {}; The error was:\n{}", (Object)url.toExternalForm(), (Object)value);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public void destroy() throws Exception {
        EXECUTOR_SERVICE.shutdown();
    }

    private static final class MessageSender
    implements Callable<Boolean> {
        private String url;
        private String message;
        private int readTimeout;
        private int connectionTimeout;
        private boolean followRedirects;

        public MessageSender(String url, String message, int readTimeout, int connectionTimeout, boolean followRedirects) {
            this.url = url;
            this.message = message;
            this.readTimeout = readTimeout;
            this.connectionTimeout = connectionTimeout;
            this.followRedirects = followRedirects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Boolean call() throws Exception {
            HttpURLConnection connection = null;
            BufferedReader in = null;
            try {
                LOGGER.debug("Attempting to access {}", (Object)this.url);
                URL logoutUrl = new URL(this.url);
                String output = "logoutRequest=" + URLEncoder.encode(this.message, "UTF-8");
                connection = (HttpURLConnection)logoutUrl.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setReadTimeout(this.readTimeout);
                connection.setConnectTimeout(this.connectionTimeout);
                connection.setInstanceFollowRedirects(this.followRedirects);
                connection.setRequestProperty("Content-Length", Integer.toString(output.getBytes().length));
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                DataOutputStream printout = new DataOutputStream(connection.getOutputStream());
                printout.writeBytes(output);
                printout.flush();
                printout.close();
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                boolean readInput = true;
                while (readInput) {
                    readInput = StringUtils.isNotBlank((String)in.readLine());
                }
                LOGGER.debug("Finished sending message to {}", (Object)this.url);
                Boolean bl = true;
                IOUtils.closeQuietly((Reader)in);
                if (connection != null) {
                    connection.disconnect();
                }
                return bl;
            }
            catch (SocketTimeoutException e) {
                LOGGER.warn("Socket Timeout Detected while attempting to send message to [{}]", (Object)this.url);
                Boolean bl = false;
                return bl;
            }
            catch (Exception e2) {
                LOGGER.warn("Error Sending message to url endpoint [{}]. Error is [{}]", (Object)this.url, (Object)e2.getMessage());
                Boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(in);
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }
}

