/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.authentication.AllAuthenticationPolicy;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PolicyBasedAuthenticationManager;
import org.jasig.cas.authentication.RequiredHandlerAuthenticationPolicy;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PolicyBasedAuthenticationManagerTests {
    @Test
    public void testAuthenticateAnySuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test
    public void testAuthenticateAnyButTryAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        AnyAuthenticationPolicy any = new AnyAuthenticationPolicy();
        any.setTryAll(true);
        manager.setAuthenticationPolicy((AuthenticationPolicy)any);
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)1L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticateAnyFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(false), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void testAuthenticateAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(true), PolicyBasedAuthenticationManagerTests.newMockHandler(true)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new AllAuthenticationPolicy());
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)2L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticateAllFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler(false), PolicyBasedAuthenticationManagerTests.newMockHandler(false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new AllAuthenticationPolicy());
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void testAuthenticateRequiredHandlerSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy("HandlerA"));
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)0L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticateRequiredHandlerFailure() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        manager.setAuthenticationPolicy((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy("HandlerB"));
        manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.fail((String)"Should have thrown AuthenticationException");
    }

    @Test
    public void testAuthenticateRequiredHandlerTryAllSuccess() throws Exception {
        PolicyBasedAuthenticationManager manager = new PolicyBasedAuthenticationManager(new AuthenticationHandler[]{PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerA", true), PolicyBasedAuthenticationManagerTests.newMockHandler("HandlerB", false)});
        RequiredHandlerAuthenticationPolicy policy = new RequiredHandlerAuthenticationPolicy("HandlerA");
        policy.setTryAll(true);
        manager.setAuthenticationPolicy((AuthenticationPolicy)policy);
        Authentication auth = manager.authenticate(new Credential[]{(Credential)Mockito.mock(Credential.class), (Credential)Mockito.mock(Credential.class)});
        Assert.assertEquals((long)1L, (long)auth.getSuccesses().size());
        Assert.assertEquals((long)1L, (long)auth.getFailures().size());
        Assert.assertEquals((long)2L, (long)auth.getCredentials().size());
    }

    private static AuthenticationHandler newMockHandler(boolean success) throws Exception {
        return PolicyBasedAuthenticationManagerTests.newMockHandler("MockAuthenticationHandler" + System.nanoTime(), success);
    }

    private static AuthenticationHandler newMockHandler(String name, boolean success) throws Exception {
        AuthenticationHandler mock = (AuthenticationHandler)Mockito.mock(AuthenticationHandler.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        Mockito.when((Object)mock.supports((Credential)Mockito.any(Credential.class))).thenReturn((Object)true);
        if (success) {
            HandlerResult result = new HandlerResult(mock, (CredentialMetaData)Mockito.mock(CredentialMetaData.class), (Principal)new SimplePrincipal("nobody"));
            Mockito.when((Object)mock.authenticate((Credential)Mockito.any(Credential.class))).thenReturn((Object)result);
        } else {
            Mockito.when((Object)mock.authenticate((Credential)Mockito.any(Credential.class))).thenThrow(new Throwable[]{new FailedLoginException()});
        }
        return mock;
    }
}

