/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.SimpleHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class HttpBasedServiceCredentialsAuthenticationHandlerTests {
    private HttpBasedServiceCredentialsAuthenticationHandler authenticationHandler;

    @Before
    public void setUp() throws Exception {
        this.authenticationHandler = new HttpBasedServiceCredentialsAuthenticationHandler();
        this.authenticationHandler.setHttpClient((HttpClient)new SimpleHttpClient());
    }

    @Test
    public void testSupportsProperUserCredentials() {
        Assert.assertTrue((boolean)this.authenticationHandler.supports((Credential)TestUtils.getHttpBasedServiceCredentials()));
    }

    @Test
    public void testDoesntSupportBadUserCredentials() {
        Assert.assertFalse((boolean)this.authenticationHandler.supports((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword()));
    }

    @Test
    public void testAcceptsProperCertificateCredentials() throws Exception {
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials()));
    }

    @Test(expected=FailedLoginException.class)
    public void testRejectsInProperCertificateCredentials() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://clearinghouse.ja-sig.org"));
    }

    @Test(expected=FailedLoginException.class)
    public void testRejectsNonHttpsCredentials() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("http://www.jasig.org"));
    }

    @Test
    public void testAcceptsNonHttpsCredentials() throws Exception {
        this.authenticationHandler.setHttpClient((HttpClient)new SimpleHttpClient());
        this.authenticationHandler.setRequireSecure(false);
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("http://www.jasig.org")));
    }

    @Test(expected=FailedLoginException.class)
    public void testNoAcceptableStatusCode() throws Exception {
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://clue.acs.rutgers.edu"));
    }

    @Test(expected=FailedLoginException.class)
    public void testNoAcceptableStatusCodeButOneSet() throws Exception {
        SimpleHttpClient httpClient = new SimpleHttpClient();
        httpClient.setAcceptableCodes(new int[]{900});
        this.authenticationHandler.setHttpClient((HttpClient)httpClient);
        this.authenticationHandler.authenticate((Credential)TestUtils.getHttpBasedServiceCredentials("https://www.ja-sig.org"));
    }
}

