/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jasig.cas.monitor.AbstractPoolMonitor;
import org.jasig.cas.monitor.PoolStatus;
import org.jasig.cas.monitor.StatusCode;
import org.junit.Assert;
import org.junit.Test;

public class AbstractPoolMonitorTests {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Test
    public void testObserveOK() throws Exception {
        AbstractPoolMonitor monitor = new AbstractPoolMonitor(){

            protected StatusCode checkPool() throws Exception {
                return StatusCode.OK;
            }

            protected int getIdleCount() {
                return 3;
            }

            protected int getActiveCount() {
                return 2;
            }
        };
        monitor.setExecutor(this.executor);
        monitor.setMaxWait(1000);
        PoolStatus status = monitor.observe();
        Assert.assertEquals((Object)StatusCode.OK, (Object)status.getCode());
        Assert.assertEquals((long)3L, (long)status.getIdleCount());
        Assert.assertEquals((long)2L, (long)status.getActiveCount());
    }

    @Test
    public void testObserveWarn() throws Exception {
        AbstractPoolMonitor monitor = new AbstractPoolMonitor(){

            protected StatusCode checkPool() throws Exception {
                Thread.sleep(1000L);
                return StatusCode.OK;
            }

            protected int getIdleCount() {
                return 1;
            }

            protected int getActiveCount() {
                return 1;
            }
        };
        monitor.setExecutor(this.executor);
        monitor.setMaxWait(500);
        PoolStatus status = monitor.observe();
        Assert.assertEquals((Object)StatusCode.WARN, (Object)status.getCode());
        Assert.assertEquals((long)1L, (long)status.getIdleCount());
        Assert.assertEquals((long)1L, (long)status.getActiveCount());
    }

    @Test
    public void testObserveError() throws Exception {
        AbstractPoolMonitor monitor = new AbstractPoolMonitor(){

            protected StatusCode checkPool() throws Exception {
                throw new RuntimeException("Pool check failed due to rogue penguins.");
            }

            protected int getIdleCount() {
                return 1;
            }

            protected int getActiveCount() {
                return 1;
            }
        };
        monitor.setExecutor(this.executor);
        monitor.setMaxWait(500);
        PoolStatus status = monitor.observe();
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)status.getCode());
        Assert.assertEquals((long)1L, (long)status.getIdleCount());
        Assert.assertEquals((long)1L, (long)status.getActiveCount());
    }
}

