/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jasig.cas.services.JpaServiceRegistryDaoImpl;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;

@ContextConfiguration(locations={"classpath:jpaTestApplicationContext.xml"})
public class JpaServiceRegistryDaoImplTests
extends AbstractTransactionalJUnit4SpringContextTests {
    @Autowired(required=true)
    private JpaServiceRegistryDaoImpl dao;

    @Test
    public void testSaveMethodWithNonExistentServiceAndNoAttributes() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("test");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
    }

    @Test
    public void testSaveMethodWithNonExistentServiceAndAttributes() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("test");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        r.setAllowedAttributes(Arrays.asList("Test"));
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
        Assert.assertTrue((boolean)r.getAllowedAttributes().contains("Test"));
    }

    @Test
    public void testSaveMethodWithExistingServiceNoAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("test");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        this.dao.save((RegisteredService)r);
        List services = this.dao.load();
        RegisteredService r2 = (RegisteredService)services.get(0);
        r.setId(r2.getId());
        r.setTheme("mytheme");
        this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r.getTheme(), (Object)r3.getTheme());
    }

    @Test
    public void testSaveMethodWithExistingServiceAddAttribute() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setName("test");
        r.setServiceId("testId");
        r.setTheme("theme");
        r.setDescription("description");
        this.dao.save((RegisteredService)r);
        List services = this.dao.load();
        RegisteredService r2 = (RegisteredService)services.get(0);
        r.setId(r2.getId());
        r.setTheme("mytheme");
        r.setAllowedAttributes(Arrays.asList("Test"));
        this.dao.save((RegisteredService)r);
        RegisteredService r3 = this.dao.findServiceById(r.getId());
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r.getTheme(), (Object)r3.getTheme());
        Assert.assertTrue((boolean)r3.getAllowedAttributes().contains("Test"));
        r.setAllowedAttributes(new ArrayList());
        this.dao.save((RegisteredService)r);
        RegisteredService r4 = this.dao.findServiceById(r.getId());
        Assert.assertTrue((boolean)r4.getAllowedAttributes().isEmpty());
    }
}

