/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.ArrayList;
import java.util.Map;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class TicketGrantingTicketImplTests {
    private UniqueTicketIdGenerator uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();

    @Test
    public void testEquals() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertFalse((boolean)t.equals(null));
        Assert.assertFalse((boolean)t.equals(new Object()));
        Assert.assertTrue((boolean)t.equals(t));
    }

    @Test(expected=Exception.class)
    public void testNullAuthentication() {
        new TicketGrantingTicketImpl("test", null, null, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }

    @Test
    public void testGetAuthentication() {
        Authentication authentication = TestUtils.getAuthentication();
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, authentication, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)t.getAuthentication(), (Object)authentication);
        Assert.assertEquals((Object)t.getId(), (Object)t.toString());
    }

    @Test
    public void testIsRootTrue() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertTrue((boolean)t.isRoot());
    }

    @Test
    public void testIsRootFalse() {
        TicketGrantingTicketImpl t1 = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", (TicketGrantingTicket)t1, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertFalse((boolean)t.isRoot());
    }

    @Test
    public void testGetChainedPrincipalsWithOne() {
        Authentication authentication = TestUtils.getAuthentication();
        ArrayList<Authentication> principals = new ArrayList<Authentication>();
        principals.add(authentication);
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, authentication, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals(principals, (Object)t.getChainedAuthentications());
    }

    @Test
    public void testCheckCreationTime() {
        Authentication authentication = TestUtils.getAuthentication();
        ArrayList<Authentication> principals = new ArrayList<Authentication>();
        principals.add(authentication);
        long startTime = System.currentTimeMillis();
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, authentication, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        long finishTime = System.currentTimeMillis();
        Assert.assertTrue((startTime <= t.getCreationTime() && finishTime >= t.getCreationTime() ? 1 : 0) != 0);
    }

    @Test
    public void testGetChainedPrincipalsWithTwo() {
        Authentication authentication = TestUtils.getAuthentication();
        Authentication authentication1 = TestUtils.getAuthentication("test1");
        ArrayList<Authentication> principals = new ArrayList<Authentication>();
        principals.add(authentication);
        principals.add(authentication1);
        TicketGrantingTicketImpl t1 = new TicketGrantingTicketImpl("test", null, authentication1, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", (TicketGrantingTicket)t1, authentication, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals(principals, (Object)t.getChainedAuthentications());
    }

    @Test
    public void testServiceTicketAsFromInitialCredentials() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        Assert.assertTrue((boolean)s.isFromNewLogin());
    }

    @Test
    public void testServiceTicketAsFromNotInitialCredentials() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        Assert.assertFalse((boolean)s.isFromNewLogin());
    }

    @Test
    public void testWebApplicationServices() {
        MockService testService = new MockService("test");
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), (Service)testService, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        Map services = t.getServices();
        Assert.assertEquals((long)1L, (long)services.size());
        String ticketId = (String)services.keySet().iterator().next();
        Assert.assertEquals((Object)testService, services.get(ticketId));
        t.removeAllServices();
        services = t.getServices();
        Assert.assertEquals((long)0L, (long)services.size());
    }

    @Test
    public void testWebApplicationExpire() {
        MockService testService = new MockService("test");
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", null, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), (Service)testService, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        Assert.assertFalse((boolean)t.isExpired());
        t.markTicketExpired();
        Assert.assertTrue((boolean)t.isExpired());
    }
}

