/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRegistryCleanerTests {
    private RegistryCleaner registryCleaner;
    private TicketRegistry ticketRegistry;

    @Before
    public void setUp() throws Exception {
        this.ticketRegistry = this.getNewTicketRegistry();
        this.registryCleaner = this.getNewRegistryCleaner(this.ticketRegistry);
    }

    public abstract RegistryCleaner getNewRegistryCleaner(TicketRegistry var1);

    public abstract TicketRegistry getNewTicketRegistry();

    @Test
    public void testCleanEmptyTicketRegistry() {
        this.registryCleaner.clean();
        Assert.assertTrue((boolean)this.ticketRegistry.getTickets().isEmpty());
    }

    @Test
    public void testCleanRegistryOfExpiredTicketsAllExpired() {
        this.populateRegistryWithExpiredTickets();
        this.registryCleaner.clean();
        Assert.assertTrue((boolean)this.ticketRegistry.getTickets().isEmpty());
    }

    @Test
    public void testCleanRegistryOneNonExpired() {
        this.populateRegistryWithExpiredTickets();
        TicketGrantingTicketImpl ticket = new TicketGrantingTicketImpl("testNoExpire", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        this.ticketRegistry.addTicket((Ticket)ticket);
        this.registryCleaner.clean();
        Assert.assertEquals((long)this.ticketRegistry.getTickets().size(), (long)1L);
    }

    private void populateRegistryWithExpiredTickets() {
        for (int i = 0; i < 10; ++i) {
            TicketGrantingTicketImpl ticket = new TicketGrantingTicketImpl("test" + i, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
            ticket.markTicketExpired();
            this.ticketRegistry.addTicket((Ticket)ticket);
        }
    }
}

