/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jasig.cas.ticket.registry.support.JpaLockingStrategy;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/jpaTestApplicationContext.xml"})
@ProfileValueSourceConfiguration(value=SystemProfileValueSource.class)
public class JpaLockingStrategyTests
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int CONCURRENT_SIZE = 13;
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private EntityManagerFactory factory;
    private JdbcTemplate simpleJdbcTemplate;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void afterPropertiesSet() throws Exception {
        JdbcTestUtils.deleteFromTables((JdbcTemplate)this.simpleJdbcTemplate, (String[])new String[]{"locks"});
    }

    @Test
    public void testAcquireAndRelease() throws Exception {
        String appId = "basic";
        String uniqueId = "basic-1";
        LockingStrategy lock = this.newLockTxProxy("basic", "basic-1", 3600);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"basic-1", (Object)this.getOwner("basic"));
            lock.release();
            Assert.assertNull((Object)this.getOwner("basic"));
        }
        catch (Exception e) {
            this.logger.debug("testAcquireAndRelease produced an error", (Throwable)e);
            Assert.fail((String)"testAcquireAndRelease failed");
        }
    }

    @Test
    public void testLockExpiration() throws Exception {
        String appId = "expquick";
        String uniqueId = "expquick-1";
        LockingStrategy lock = this.newLockTxProxy("expquick", "expquick-1", 1);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"expquick-1", (Object)this.getOwner("expquick"));
            Assert.assertFalse((boolean)lock.acquire());
            Thread.sleep(1500L);
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"expquick-1", (Object)this.getOwner("expquick"));
            lock.release();
            Assert.assertNull((Object)this.getOwner("expquick"));
        }
        catch (Exception e) {
            this.logger.debug("testLockExpiration produced an error", (Throwable)e);
            Assert.fail((String)"testLockExpiration failed");
        }
    }

    @Test
    public void testNonReentrantBehavior() {
        String appId = "reentrant";
        String uniqueId = "reentrant-1";
        LockingStrategy lock = this.newLockTxProxy("reentrant", "reentrant-1", 3600);
        try {
            Assert.assertTrue((boolean)lock.acquire());
            Assert.assertEquals((Object)"reentrant-1", (Object)this.getOwner("reentrant"));
            Assert.assertFalse((boolean)lock.acquire());
            lock.release();
            Assert.assertNull((Object)this.getOwner("reentrant"));
        }
        catch (Exception e) {
            this.logger.debug("testNonReentrantBehavior produced an error", (Throwable)e);
            Assert.fail((String)"testNonReentrantBehavior failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IfProfileValue(name="cas.jpa.concurrent", value="true")
    public void testConcurrentAcquireAndRelease() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(13);
        try {
            this.testConcurrency(executor, this.getConcurrentLocks("concurrent-new"));
        }
        catch (Exception e) {
            this.logger.debug("testConcurrentAcquireAndRelease produced an error", (Throwable)e);
            Assert.fail((String)"testConcurrentAcquireAndRelease failed.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IfProfileValue(name="cas.jpa.concurrent", value="true")
    public void testConcurrentAcquireAndReleaseOnExistingLock() throws Exception {
        LockingStrategy[] locks = this.getConcurrentLocks("concurrent-exists");
        locks[0].acquire();
        locks[0].release();
        ExecutorService executor = Executors.newFixedThreadPool(13);
        try {
            this.testConcurrency(executor, locks);
        }
        catch (Exception e) {
            this.logger.debug("testConcurrentAcquireAndReleaseOnExistingLock produced an error", (Throwable)e);
            Assert.fail((String)"testConcurrentAcquireAndReleaseOnExistingLock failed.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    private LockingStrategy[] getConcurrentLocks(String appId) {
        LockingStrategy[] locks = new LockingStrategy[13];
        for (int i = 1; i <= locks.length; ++i) {
            locks[i - 1] = this.newLockTxProxy(appId, appId + "-" + i, 3600);
        }
        return locks;
    }

    private LockingStrategy newLockTxProxy(String appId, String uniqueId, int ttl) {
        JpaLockingStrategy lock = new JpaLockingStrategy();
        lock.entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.factory);
        lock.setApplicationId(appId);
        lock.setUniqueId(uniqueId);
        lock.setLockTimeout(ttl);
        return (LockingStrategy)Proxy.newProxyInstance(JpaLockingStrategy.class.getClassLoader(), new Class[]{LockingStrategy.class}, (InvocationHandler)new TransactionalLockInvocationHandler(lock));
    }

    private String getOwner(String appId) {
        List results = this.simpleJdbcTemplate.queryForList("SELECT unique_id FROM locks WHERE application_id=?", new Object[]{appId});
        if (results.size() == 0) {
            return null;
        }
        return (String)((Map)results.get(0)).get("unique_id");
    }

    private void testConcurrency(ExecutorService executor, LockingStrategy[] locks) throws Exception {
        ArrayList<Locker> lockers = new ArrayList<Locker>(locks.length);
        for (int i = 0; i < locks.length; ++i) {
            lockers.add(new Locker(locks[i]));
        }
        int lockCount = 0;
        for (Future result : executor.invokeAll(lockers)) {
            if (!((Boolean)result.get()).booleanValue()) continue;
            ++lockCount;
        }
        Assert.assertTrue((String)("Lock count should be <= 1 but was " + lockCount), (lockCount <= 1 ? 1 : 0) != 0);
        ArrayList<Releaser> releasers = new ArrayList<Releaser>(locks.length);
        for (int i = 0; i < locks.length; ++i) {
            releasers.add(new Releaser(locks[i]));
        }
        int releaseCount = 0;
        for (Future result : executor.invokeAll(lockers)) {
            if (!((Boolean)result.get()).booleanValue()) continue;
            ++releaseCount;
        }
        Assert.assertTrue((String)("Release count should be <= 1 but was " + releaseCount), (releaseCount <= 1 ? 1 : 0) != 0);
    }

    class Releaser
    implements Callable<Boolean> {
        private LockingStrategy lock;

        public Releaser(LockingStrategy l) {
            this.lock = l;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                this.lock.release();
                return true;
            }
            catch (Exception e) {
                JpaLockingStrategyTests.this.logger.debug("{} failed to release lock", (Object)this.lock, (Object)e);
                return false;
            }
        }
    }

    class Locker
    implements Callable<Boolean> {
        private LockingStrategy lock;

        public Locker(LockingStrategy l) {
            this.lock = l;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                return this.lock.acquire();
            }
            catch (Exception e) {
                JpaLockingStrategyTests.this.logger.debug("{} failed to acquire lock", (Object)this.lock, (Object)e);
                return false;
            }
        }
    }

    class TransactionalLockInvocationHandler
    implements InvocationHandler {
        private JpaLockingStrategy jpaLock;

        public TransactionalLockInvocationHandler(JpaLockingStrategy lock) {
            this.jpaLock = lock;
        }

        public JpaLockingStrategy getLock() {
            return this.jpaLock;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            return new TransactionTemplate(JpaLockingStrategyTests.this.txManager).execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    try {
                        Object result = method.invoke((Object)TransactionalLockInvocationHandler.this.jpaLock, args);
                        ((TransactionalLockInvocationHandler)TransactionalLockInvocationHandler.this).jpaLock.entityManager.flush();
                        JpaLockingStrategyTests.this.logger.debug("Performed {} on {}", (Object)method.getName(), (Object)TransactionalLockInvocationHandler.this.jpaLock);
                        return result;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Transactional method invocation failed.", e);
                    }
                }
            });
        }
    }
}

