/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTimeUseOrTimeoutExpirationPolicyTests {
    private static final long TIMEOUT_MILLISECONDS = 100L;
    private static final int NUMBER_OF_USES = 5;
    private static final int TIMEOUT_BUFFER = 50;
    private ExpirationPolicy expirationPolicy;
    private TicketGrantingTicket ticket;

    @Before
    public void setUp() throws Exception {
        this.expirationPolicy = new MultiTimeUseOrTimeoutExpirationPolicy(5, 100L, TimeUnit.MILLISECONDS);
        this.ticket = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), this.expirationPolicy);
    }

    @Test
    public void testTicketIsNull() {
        Assert.assertTrue((boolean)this.expirationPolicy.isExpired(null));
    }

    @Test
    public void testTicketIsNotExpired() {
        Assert.assertFalse((boolean)this.ticket.isExpired());
    }

    @Test
    public void testTicketIsExpiredByTime() throws InterruptedException {
        Thread.sleep(150L);
        Assert.assertTrue((boolean)this.ticket.isExpired());
    }

    @Test
    public void testTicketIsExpiredByCount() {
        for (int i = 0; i < 5; ++i) {
            this.ticket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        }
        Assert.assertTrue((boolean)this.ticket.isExpired());
    }
}

