/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jasig.cas.util.SimpleHttpClient;
import org.junit.Assert;
import org.junit.Test;

public class SimpleHttpClientTests {
    private SimpleHttpClient getHttpClient() {
        SimpleHttpClient httpClient = new SimpleHttpClient();
        httpClient.setConnectionTimeout(1000);
        httpClient.setReadTimeout(1000);
        return httpClient;
    }

    @Test
    public void testOkayUrl() {
        Assert.assertTrue((boolean)this.getHttpClient().isValidEndPoint("http://www.jasig.org"));
    }

    @Test
    public void testBadUrl() {
        Assert.assertFalse((boolean)this.getHttpClient().isValidEndPoint("https://www.abc1234.org"));
    }

    @Test
    public void testInvalidHttpsUrl() {
        SimpleHttpClient client = this.getHttpClient();
        Assert.assertFalse((boolean)client.isValidEndPoint("https://static.ak.connect.facebook.com"));
    }

    @Test
    public void testBypassedInvalidHttpsUrl() throws Exception {
        SimpleHttpClient client = this.getHttpClient();
        client.setSSLSocketFactory(this.getFriendlyToAllSSLSocketFactory());
        client.setHostnameVerifier(this.getFriendlyToAllHostnameVerifier());
        client.setAcceptableCodes(new int[]{200, 403});
        Assert.assertTrue((boolean)client.isValidEndPoint("https://static.ak.connect.facebook.com"));
    }

    private HostnameVerifier getFriendlyToAllHostnameVerifier() {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        return hv;
    }

    private SSLSocketFactory getFriendlyToAllSSLSocketFactory() throws Exception {
        X509TrustManager trm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{trm}, null);
        return sc.getSocketFactory();
    }
}

