/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1227390629186486032L;
    private String code;
    private String defaultMessage;
    private Serializable[] params;

    public Message(String code) {
        this(code, code, new Serializable[0]);
    }

    public Message(String code, String defaultMessage, Serializable ... params) {
        Assert.hasText((String)code, (String)"Code cannot be null or empty");
        Assert.hasText((String)defaultMessage, (String)"Default message cannot be null or empty");
        this.code = code;
        this.defaultMessage = defaultMessage;
        this.params = params;
    }

    public String getCode() {
        return this.code;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Serializable[] getParams() {
        return this.params;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(99, 31);
        builder.append((Object)this.code);
        builder.append((Object)this.defaultMessage);
        builder.append((Object[])this.params);
        return builder.toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Message)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Message m = (Message)other;
        return this.code.equals(m.getCode()) && this.defaultMessage.equals(m.getDefaultMessage()) && Arrays.equals(this.params, m.getParams());
    }
}

